/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.jpa;

import de.openknowledge.cdi.jpa.JpaInjectionTestBean;
import de.openknowledge.cdi.jpa.PersistenceContext;
import de.openknowledge.cdi.jpa.PersistenceUnit;
import de.openknowledge.cdi.test.CdiJunit4TestRunner;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=CdiJunit4TestRunner.class)
public class JpaExtensionTest {
    @Inject
    private MockProducer mockProducer;
    @Inject
    private JpaInjectionTestBean testBean;

    @Test
    public void injection() {
        Assert.assertSame((Object)this.mockProducer.defaultEntityManagerFactory, (Object)this.testBean.getDefaultFieldInjectedEntityManagerFactory());
        Assert.assertSame((Object)this.mockProducer.defaultEntityManagerFactory, (Object)this.testBean.getDefaultMethodInjectedEntityManagerFactory());
        Assert.assertSame((Object)this.mockProducer.defaultEntityManager, (Object)this.testBean.getDefaultFieldInjectedEntityManager());
        Assert.assertSame((Object)this.mockProducer.defaultEntityManager, (Object)this.testBean.getDefaultMethodInjectedEntityManager());
        Assert.assertSame((Object)this.mockProducer.customEntityManagerFactory, (Object)this.testBean.getCustomFieldInjectedEntityManagerFactory());
        Assert.assertSame((Object)this.mockProducer.customEntityManagerFactory, (Object)this.testBean.getCustomMethodInjectedEntityManagerFactory());
        Assert.assertSame((Object)this.mockProducer.customEntityManager, (Object)this.testBean.getCustomFieldInjectedEntityManager());
        Assert.assertSame((Object)this.mockProducer.customEntityManager, (Object)this.testBean.getCustomMethodInjectedEntityManager());
    }

    @Singleton
    private static class MockProducer {
        @Produces
        @PersistenceContext
        private EntityManagerFactory defaultEntityManagerFactory = (EntityManagerFactory)EasyMock.createMock(EntityManagerFactory.class);
        @Produces
        @PersistenceUnit
        private EntityManager defaultEntityManager = (EntityManager)EasyMock.createMock(EntityManager.class);
        @Produces
        @PersistenceContext(unitName="custom", type=PersistenceContextType.TRANSACTION)
        private EntityManagerFactory transactionalEntityManagerFactory = (EntityManagerFactory)EasyMock.createMock(EntityManagerFactory.class);
        @Produces
        @PersistenceUnit(unitName="transactional")
        private EntityManager transactionalEntityManager = (EntityManager)EasyMock.createMock(EntityManager.class);
        @Produces
        @PersistenceContext(unitName="custom", type=PersistenceContextType.EXTENDED)
        private EntityManagerFactory customEntityManagerFactory = (EntityManagerFactory)EasyMock.createMock(EntityManagerFactory.class);
        @Produces
        @PersistenceUnit(unitName="custom")
        private EntityManager customEntityManager = (EntityManager)EasyMock.createMock(EntityManager.class);

        private MockProducer() {
        }
    }
}

