/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.jpa;

import de.openknowledge.cdi.common.spi.DelegatingAnnotatedField;
import de.openknowledge.cdi.common.spi.DelegatingAnnotatedMethod;
import de.openknowledge.cdi.common.spi.DelegatingAnnotatedParameter;
import de.openknowledge.cdi.common.spi.DelegatingAnnotatedType;
import de.openknowledge.cdi.common.spi.InjectLiteral;
import de.openknowledge.cdi.jpa.DelegatingPersistenceContext;
import de.openknowledge.cdi.jpa.DelegatingPersistenceUnit;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;

public class JpaExtension
implements Extension {
    public <T> void processJpaAnnotations(@Observes ProcessAnnotatedType<T> annotatedTypeEvent) {
        AnnotatedType annotatedType;
        if (annotatedTypeEvent.getAnnotatedType().isAnnotationPresent(Entity.class) || annotatedTypeEvent.getAnnotatedType().isAnnotationPresent(Embeddable.class)) {
            annotatedTypeEvent.veto();
        }
        if (this.isJpaAnnotationPresent(annotatedType = annotatedTypeEvent.getAnnotatedType())) {
            annotatedTypeEvent.setAnnotatedType(new JpaAnnotatedType(annotatedType));
        }
    }

    private boolean isJpaAnnotationPresent(AnnotatedType<?> annotatedType) {
        for (AnnotatedField field : annotatedType.getFields()) {
            if (!this.isJpaAnnotationPresent((Annotated)field)) continue;
            return true;
        }
        for (AnnotatedConstructor constructor : annotatedType.getConstructors()) {
            if (!this.isJpaAnnotationPresent((Annotated)constructor)) continue;
            return true;
        }
        for (AnnotatedMethod method : annotatedType.getMethods()) {
            if (!this.isJpaAnnotationPresent((Annotated)method)) continue;
            return true;
        }
        return false;
    }

    private boolean isJpaAnnotationPresent(Annotated annotated) {
        return annotated.isAnnotationPresent(PersistenceUnit.class) || annotated.isAnnotationPresent(PersistenceContext.class);
    }

    private static Class<?> toClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return JpaExtension.toClass(((ParameterizedType)type).getRawType());
        }
        throw new IllegalArgumentException("Cannot convert type to class: " + type);
    }

    private static class PersistenceUnitMethod<T>
    extends DelegatingAnnotatedMethod<T> {
        private PersistenceUnit persistenceUnit;

        public PersistenceUnitMethod(AnnotatedType<T> declaringType, AnnotatedMethod<T> delegate) {
            super(declaringType, delegate, new Annotation[0]);
            this.persistenceUnit = (PersistenceUnit)delegate.getAnnotation(PersistenceUnit.class);
            this.removeAnnotation(this.persistenceUnit.annotationType());
            if (!delegate.isAnnotationPresent(Produces.class)) {
                this.addAnnotation((Annotation)new InjectLiteral());
            }
        }

        protected AnnotatedParameter<T> processAnnotatedParameter(AnnotatedParameter<T> annotatedParameter) {
            if (EntityManager.class.isAssignableFrom(JpaExtension.toClass(annotatedParameter.getBaseType()))) {
                return new DelegatingAnnotatedParameter((AnnotatedCallable)this, annotatedParameter, new Annotation[]{this.createPersistenceUnitAnnotation()});
            }
            return annotatedParameter;
        }

        private DelegatingPersistenceUnit createPersistenceUnitAnnotation() {
            return new DelegatingPersistenceUnit(this.persistenceUnit);
        }
    }

    private static class PersistenceContextMethod<T>
    extends DelegatingAnnotatedMethod<T> {
        private PersistenceContext persistenceContext;

        public PersistenceContextMethod(AnnotatedType<T> declaringType, AnnotatedMethod<T> delegate) {
            super(declaringType, delegate, new Annotation[0]);
            this.persistenceContext = (PersistenceContext)delegate.getAnnotation(PersistenceContext.class);
            this.removeAnnotation(this.persistenceContext.annotationType());
            if (!delegate.isAnnotationPresent(Produces.class)) {
                this.addAnnotation((Annotation)new InjectLiteral());
            }
        }

        protected AnnotatedParameter<T> processAnnotatedParameter(AnnotatedParameter<T> annotatedParameter) {
            if (EntityManagerFactory.class.isAssignableFrom(JpaExtension.toClass(annotatedParameter.getBaseType()))) {
                return new DelegatingAnnotatedParameter((AnnotatedCallable)this, annotatedParameter, new Annotation[]{this.createPersistenceContextAnnotation()});
            }
            return annotatedParameter;
        }

        private DelegatingPersistenceContext createPersistenceContextAnnotation() {
            return new DelegatingPersistenceContext(this.persistenceContext);
        }
    }

    private static class JpaAnnotatedType<T>
    extends DelegatingAnnotatedType<T> {
        public JpaAnnotatedType(AnnotatedType<T> delegate) {
            super(delegate, new Annotation[0]);
        }

        protected AnnotatedField<? super T> processAnnotatedField(AnnotatedField<? super T> field) {
            if (field.isAnnotationPresent(PersistenceContext.class)) {
                return this.createPersistenceContextField(field, (PersistenceContext)field.getAnnotation(PersistenceContext.class));
            }
            if (field.isAnnotationPresent(PersistenceUnit.class)) {
                return this.createPersistenceUnitField(field, (PersistenceUnit)field.getAnnotation(PersistenceUnit.class));
            }
            return super.processAnnotatedField(field);
        }

        protected AnnotatedMethod<? super T> processAnnotatedMethod(AnnotatedMethod<? super T> method) {
            if (method.isAnnotationPresent(PersistenceContext.class)) {
                return this.createPersistenceContextMethod(method);
            }
            if (method.isAnnotationPresent(PersistenceUnit.class)) {
                return this.createPersistenceUnitMethod(method);
            }
            return super.processAnnotatedMethod(method);
        }

        private <A> AnnotatedField<A> createPersistenceContextField(AnnotatedField<A> field, PersistenceContext delegate) {
            DelegatingAnnotatedField delegateField = new DelegatingAnnotatedField((AnnotatedType)this, field, new Annotation[0]);
            delegateField.removeAnnotation(delegate.annotationType());
            delegateField.addAnnotation((Annotation)new DelegatingPersistenceContext(delegate));
            if (!field.isAnnotationPresent(Produces.class)) {
                delegateField.addAnnotation((Annotation)new InjectLiteral());
            }
            return delegateField;
        }

        private <A> AnnotatedField<A> createPersistenceUnitField(AnnotatedField<A> field, PersistenceUnit delegate) {
            DelegatingAnnotatedField delegateField = new DelegatingAnnotatedField((AnnotatedType)this, field, new Annotation[0]);
            delegateField.removeAnnotation(delegate.annotationType());
            delegateField.addAnnotation((Annotation)new DelegatingPersistenceUnit(delegate));
            if (!field.isAnnotationPresent(Produces.class)) {
                delegateField.addAnnotation((Annotation)new InjectLiteral());
            }
            return delegateField;
        }

        private <A> AnnotatedMethod<A> createPersistenceContextMethod(AnnotatedMethod<A> method) {
            if (method.isAnnotationPresent(Produces.class)) {
                DelegatingAnnotatedMethod delegatingMethod = new DelegatingAnnotatedMethod((AnnotatedType)this, method, new Annotation[0]);
                PersistenceContext persistenceContext = (PersistenceContext)method.getAnnotation(PersistenceContext.class);
                delegatingMethod.removeAnnotation(persistenceContext.annotationType());
                delegatingMethod.addAnnotation((Annotation)new DelegatingPersistenceContext(persistenceContext));
                return delegatingMethod;
            }
            return new PersistenceContextMethod<A>(this, method);
        }

        private <A> AnnotatedMethod<A> createPersistenceUnitMethod(AnnotatedMethod<A> method) {
            if (method.isAnnotationPresent(Produces.class)) {
                DelegatingAnnotatedMethod delegatingMethod = new DelegatingAnnotatedMethod((AnnotatedType)this, method, new Annotation[0]);
                PersistenceUnit persistenceUnit = (PersistenceUnit)method.getAnnotation(PersistenceUnit.class);
                delegatingMethod.removeAnnotation(persistenceUnit.annotationType());
                delegatingMethod.addAnnotation((Annotation)new DelegatingPersistenceUnit(persistenceUnit));
                return delegatingMethod;
            }
            return new PersistenceUnitMethod<A>(this, method);
        }
    }
}

