/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.monitoring;

import de.openknowledge.cdi.monitoring.ComponentStatus;
import de.openknowledge.cdi.monitoring.ComponentStatusType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.SystemUtils;

public class HealthStatusQueryCommand {
    private Map<ComponentStatusType, Set<ComponentStatus>> status = new HashMap<ComponentStatusType, Set<ComponentStatus>>();

    public HealthStatusQueryCommand() {
        this.status.put(ComponentStatusType.ERROR, new HashSet());
        this.status.put(ComponentStatusType.WARNING, new HashSet());
        this.status.put(ComponentStatusType.OK, new HashSet());
    }

    public void reportStatus(ComponentStatus aStatus) {
        this.status.get((Object)aStatus.getStatus()).add(aStatus);
    }

    public boolean hasErrors() {
        return this.status.get((Object)ComponentStatusType.ERROR).size() > 0;
    }

    public boolean hasWarnings() {
        return this.status.get((Object)ComponentStatusType.WARNING).size() > 0;
    }

    public boolean isOK() {
        return !this.hasErrors() && !this.hasWarnings();
    }

    public Map<ComponentStatusType, Set<ComponentStatus>> getStatus() {
        return Collections.unmodifiableMap(this.status);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.isOK()) {
            buffer.append("OK");
        } else {
            this.appendAll(buffer, this.status.get((Object)ComponentStatusType.ERROR));
            this.appendAll(buffer, this.status.get((Object)ComponentStatusType.WARNING));
            this.appendAll(buffer, this.status.get((Object)ComponentStatusType.OK));
        }
        return buffer.toString();
    }

    private void appendAll(StringBuffer aBuffer, Set<ComponentStatus> aComponentStatuses) {
        for (ComponentStatus status : aComponentStatuses) {
            aBuffer.append(status);
            aBuffer.append(SystemUtils.LINE_SEPARATOR);
        }
    }
}

