/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.transaction.jta;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.easymock.EasyMock;

public class StrictMockTransactionFactory {
    private StrictMockTransaction mockTransaction;
    private Transaction suspendedTransaction;
    private boolean recording = false;

    public StrictMockTransaction getMockTransaction() {
        if (this.mockTransaction == null) {
            this.mockTransaction = (StrictMockTransaction)EasyMock.createStrictMock(StrictMockTransaction.class);
            this.recording = true;
        }
        return this.mockTransaction;
    }

    public void expectNoTransaction() throws Exception {
        if (!this.recording) {
            EasyMock.reset((Object[])new Object[]{this.getMockTransaction()});
            this.recording = true;
        }
        EasyMock.expect((Object)this.mockTransaction.getStatus()).andReturn((Object)6).atLeastOnce();
    }

    public void expectActiveTransaction() throws Exception {
        if (!this.recording) {
            EasyMock.reset((Object[])new Object[]{this.getMockTransaction()});
            this.recording = true;
        }
        EasyMock.expect((Object)this.mockTransaction.getStatus()).andReturn((Object)0).anyTimes();
    }

    public void expectSuspendTransaction() throws Exception {
        if (!this.recording) {
            EasyMock.reset((Object[])new Object[]{this.getMockTransaction()});
            this.recording = true;
        }
        this.suspendedTransaction = (Transaction)EasyMock.createStrictMock(Transaction.class);
        EasyMock.expect((Object)this.mockTransaction.suspend()).andReturn((Object)this.suspendedTransaction);
        EasyMock.expect((Object)this.mockTransaction.getStatus()).andReturn((Object)6).anyTimes();
    }

    public void expectResumeTransaction() throws Exception {
        this.mockTransaction.resume(this.suspendedTransaction);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.mockTransaction.getStatus()).andReturn((Object)0).anyTimes();
    }

    public void expectBeginTransaction() throws Exception {
        if (!this.recording) {
            EasyMock.reset((Object[])new Object[]{this.getMockTransaction()});
            this.recording = true;
        }
        this.mockTransaction.begin();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.mockTransaction.getStatus()).andReturn((Object)0).anyTimes();
    }

    public void expectCommitTransaction() throws Exception {
        if (!this.recording) {
            EasyMock.reset((Object[])new Object[]{this.getMockTransaction()});
            this.recording = true;
        }
        this.mockTransaction.commit();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.mockTransaction.getStatus()).andReturn((Object)3).anyTimes();
    }

    public void expectSetRollbackOnly() throws Exception {
        if (!this.recording) {
            EasyMock.reset((Object[])new Object[]{this.getMockTransaction()});
            this.recording = true;
        }
        this.mockTransaction.setRollbackOnly();
        EasyMock.expectLastCall().atLeastOnce();
        EasyMock.expect((Object)this.mockTransaction.getStatus()).andReturn((Object)1).anyTimes();
    }

    public void expectRollbackTransaction() throws Exception {
        if (!this.recording) {
            EasyMock.reset((Object[])new Object[]{this.getMockTransaction()});
            this.recording = true;
        }
        this.mockTransaction.rollback();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.mockTransaction.getStatus()).andReturn((Object)4).anyTimes();
    }

    public void replay() {
        if (this.suspendedTransaction != null) {
            EasyMock.replay((Object[])new Object[]{this.suspendedTransaction});
        }
        EasyMock.replay((Object[])new Object[]{this.mockTransaction});
    }

    public void verify() {
        if (this.suspendedTransaction != null) {
            EasyMock.verify((Object[])new Object[]{this.suspendedTransaction});
        }
        EasyMock.verify((Object[])new Object[]{this.mockTransaction});
    }

    public static interface StrictMockTransaction
    extends UserTransaction,
    TransactionManager {
    }
}

