/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.util.dge.filter;

import de.openknowledge.util.dge.filter.FilterExpression;
import de.openknowledge.util.dge.filter.FilterFieldMetaData;
import de.openknowledge.util.dge.filter.FilterFieldType;
import de.openknowledge.util.dge.filter.FilterOperand;
import de.openknowledge.util.dge.filter.annotation.FilterField;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilterExpressionTest {
    private FilteredTestLine l1;
    private FilteredTestLine l2;
    private FilteredTestLine l3;

    @Before
    public void init() {
        BigDecimal bd1 = new BigDecimal("1000");
        Calendar c1 = Calendar.getInstance();
        c1.set(2012, 0, 1, 0, 0, 0);
        c1.set(14, 0);
        this.l1 = new FilteredTestLine(bd1, c1.getTime(), "MPE");
        BigDecimal bd2 = new BigDecimal("2000");
        Calendar c2 = Calendar.getInstance();
        c2.set(2012, 0, 1, 0, 0, 0);
        c2.set(14, 0);
        this.l2 = new FilteredTestLine(bd2, c2.getTime(), "JSC");
        BigDecimal bd3 = new BigDecimal("2000");
        Calendar c3 = Calendar.getInstance();
        c3.set(2013, 0, 1, 0, 0, 0);
        c3.set(14, 0);
        this.l3 = new FilteredTestLine(bd3, c3.getTime(), "MPE");
    }

    @Test
    public void matchesBigDecimalTest() throws Exception {
        Method methodFoo = FilteredTestLine.class.getMethod("getFoo", new Class[0]);
        FilterFieldMetaData metaDataFoo = new FilterFieldMetaData(FilterFieldType.BIGDECIMAL, methodFoo, 100, "Foo");
        FilterExpression fe = metaDataFoo.createFilterExpression(FilterOperand.GT, (Object)new BigDecimal("1500"));
        Assert.assertThat((Object)fe.matches((Object)this.l1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)fe.matches((Object)this.l2), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)fe.matches((Object)this.l3), (Matcher)CoreMatchers.is((Object)true));
        fe = metaDataFoo.createFilterExpression(FilterOperand.EQ, (Object)new BigDecimal("2000"));
        Assert.assertThat((Object)fe.matches((Object)this.l1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)fe.matches((Object)this.l2), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)fe.matches((Object)this.l3), (Matcher)CoreMatchers.is((Object)true));
        fe = metaDataFoo.createFilterExpression(FilterOperand.LT, (Object)new BigDecimal("2000"));
        Assert.assertThat((Object)fe.matches((Object)this.l1), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)fe.matches((Object)this.l2), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)fe.matches((Object)this.l3), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void matchesDateTest() throws Exception {
        Method methodBar = FilteredTestLine.class.getMethod("getBar", new Class[0]);
        FilterFieldMetaData metaDataBar = new FilterFieldMetaData(FilterFieldType.DATE, methodBar, 200, "Bar");
        Calendar c = Calendar.getInstance();
        c.set(2012, 0, 1, 0, 0, 0);
        c.set(14, 0);
        FilterExpression fe = metaDataBar.createFilterExpression(FilterOperand.GT, (Object)c.getTime());
        Assert.assertThat((Object)fe.matches((Object)this.l1), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)fe.matches((Object)this.l2), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)fe.matches((Object)this.l3), (Matcher)CoreMatchers.is((Object)true));
        c.set(2012, 0, 1, 0, 0, 0);
        fe = metaDataBar.createFilterExpression(FilterOperand.EQ, (Object)c.getTime());
        Assert.assertThat((Object)fe.matches((Object)this.l1), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)fe.matches((Object)this.l2), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)fe.matches((Object)this.l3), (Matcher)CoreMatchers.is((Object)false));
        c.set(2013, 0, 1, 0, 0, 0);
        fe = metaDataBar.createFilterExpression(FilterOperand.LT, (Object)c.getTime());
        Assert.assertThat((Object)fe.matches((Object)this.l1), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)fe.matches((Object)this.l2), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)fe.matches((Object)this.l3), (Matcher)CoreMatchers.is((Object)false));
    }

    public class FilteredTestLine {
        private BigDecimal foo;
        private Date bar;
        private String yadda;

        public FilteredTestLine(BigDecimal aFoo, Date aBar, String aYadda) {
            this.foo = aFoo;
            this.bar = aBar;
            this.yadda = aYadda;
        }

        @FilterField(order=200, displayName="Bar")
        public Date getBar() {
            return this.bar;
        }

        @FilterField(order=100, displayName="Foo")
        public BigDecimal getFoo() {
            return this.foo;
        }
    }
}

