/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.util.dge.filter.web;

import de.openknowledge.util.dge.filter.FilterFieldMetaData;
import de.openknowledge.util.dge.filter.FilteredTestLine;
import de.openknowledge.util.dge.filter.web.FilterAssembler;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilterAssemblerTest {
    FilterAssembler<List> assembler;

    @Before
    public void init() {
        this.assembler = new FilterAssembler(FilteredTestLine.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetMetaDataByStringNullParam() {
        this.assembler.getMetaDataByString(null);
    }

    @Test
    public void testGetMetaDataByStringReturnValue() {
        FilterFieldMetaData metaData = this.assembler.getMetaDataByString("getFoo");
        Assert.assertNotNull((Object)metaData);
        Assert.assertNull((Object)this.assembler.getMetaDataByString("getYadda"));
    }

    @Test
    public void testRemoveFilterRow() {
        this.assembler.resetFilter();
        Assert.assertThat((Object)this.assembler.getFilterRows().size(), (Matcher)CoreMatchers.is((Object)1));
        this.assembler.addNewFilterRow();
        this.assembler.addNewFilterRow();
        Assert.assertThat((Object)this.assembler.getFilterRows().size(), (Matcher)CoreMatchers.is((Object)3));
        FilterAssembler.FilterRow row = (FilterAssembler.FilterRow)this.assembler.getFilterRows().get(0);
        this.assembler.removeFilterRow(row);
        Assert.assertThat((Object)this.assembler.getFilterRows().size(), (Matcher)CoreMatchers.is((Object)2));
        this.assembler.removeFilterRow((FilterAssembler.FilterRow)this.assembler.getFilterRows().get(0));
        this.assembler.removeFilterRow((FilterAssembler.FilterRow)this.assembler.getFilterRows().get(0));
        Assert.assertThat((Object)this.assembler.getFilterRows().size(), (Matcher)CoreMatchers.is((Object)1));
    }
}

