/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.util.dge.grouping;

import de.openknowledge.util.dge.grouping.AggregationLine;
import de.openknowledge.util.dge.grouping.AggregrationValue;
import de.openknowledge.util.dge.grouping.Group;
import de.openknowledge.util.dge.grouping.GroupingMetaData;
import de.openknowledge.util.dge.grouping.Line;
import de.openknowledge.util.dge.grouping.ValueLine;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class GroupingManager<E extends Serializable>
implements Serializable {
    private List<E> objects;
    private List<Line> groupedLines;
    private Class<E> clazz;
    private String currentGroupingMetaData;
    private transient List<GroupingMetaData> groupingMetaData;
    private transient List<Method> aggregationValueMethods;
    private boolean expandByDefault = false;

    public GroupingManager(List<E> aObjects, Class<E> aClazz) {
        this.objects = aObjects;
        this.clazz = aClazz;
        this.initGroupedLines();
    }

    public List<Line> groupBy(String groupDisplayName) throws IllegalArgumentException {
        for (GroupingMetaData metaData : this.getGroupingMetaData()) {
            if (!metaData.getDisplayName().equals(groupDisplayName)) continue;
            return this.groupBy(metaData);
        }
        this.initGroupedLines();
        return this.getGroupedLines();
    }

    public List<Line> groupBy(GroupingMetaData newGroupingMetaData) {
        Validate.notNull((Object)newGroupingMetaData);
        Map map = new HashMap();
        for (Serializable object : this.objects) {
            map = this.putOrAddValueLine(map, newGroupingMetaData.getValue(object), new ValueLine<Serializable>(object));
        }
        this.groupedLines = new ArrayList(map.values());
        Collections.sort(this.groupedLines, new Comparator<Line>(){

            @Override
            public int compare(Line o1, Line o2) {
                return ((AggregationLine)o1).getDisplayName().compareTo(((AggregationLine)o2).getDisplayName());
            }
        });
        this.currentGroupingMetaData = newGroupingMetaData.getDisplayName();
        return this.getGroupedLines();
    }

    protected void initGroupingMetaData() {
        Method[] methods = this.clazz.getMethods();
        this.aggregationValueMethods = new ArrayList<Method>();
        this.groupingMetaData = new ArrayList<GroupingMetaData>();
        for (Method method : methods) {
            AggregrationValue valueAnnotation;
            Group annotation = method.getAnnotation(Group.class);
            if (annotation != null) {
                this.groupingMetaData.add(new GroupingMetaData(annotation.displayName(), annotation.order(), method));
            }
            if ((valueAnnotation = method.getAnnotation(AggregrationValue.class)) == null) continue;
            this.aggregationValueMethods.add(method);
        }
        Collections.sort(this.groupingMetaData, new Comparator<GroupingMetaData>(){

            @Override
            public int compare(GroupingMetaData o1, GroupingMetaData o2) {
                return o1.getOrder() > o2.getOrder() ? 1 : -1;
            }
        });
    }

    protected void initGroupedLines() {
        this.groupedLines = new ArrayList<Line>();
        for (Serializable object : this.objects) {
            this.groupedLines.add(new ValueLine<Serializable>(object));
        }
    }

    protected Map putOrAddValueLine(Map map, Object key, ValueLine<E> currentLine) {
        AggregationLine<E> line = map.containsKey(key) ? (AggregationLine)map.get(key) : new AggregationLine<E>(key.toString());
        line.setExpanded(this.expandByDefault);
        line.addValueLine(currentLine, this.getAggregationValueMethods());
        map.put(key, line);
        return map;
    }

    public List<Line> getGroupedLines() {
        ArrayList<Line> lines = new ArrayList<Line>();
        for (Line line : this.groupedLines) {
            lines.add(line);
            if (!line.isExpanded()) continue;
            lines.addAll(((AggregationLine)line).getValueLines());
        }
        return lines;
    }

    public List<E> getObjects() {
        return this.objects;
    }

    public String getCurrentGroupingMetaData() {
        return this.currentGroupingMetaData;
    }

    public List<GroupingMetaData> getGroupingMetaData() {
        if (this.groupingMetaData == null) {
            this.initGroupingMetaData();
        }
        return this.groupingMetaData;
    }

    public List<Method> getAggregationValueMethods() {
        if (this.aggregationValueMethods == null) {
            this.initGroupingMetaData();
        }
        return this.aggregationValueMethods;
    }

    public boolean isExpandByDefault() {
        return this.expandByDefault;
    }

    public void setExpandByDefault(boolean aExpandByDefault) {
        this.expandByDefault = aExpandByDefault;
    }
}

