/*
 * Decompiled with CFR 0.152.
 */
package etm.demo.webapp.javaee.domain.user;

import etm.demo.webapp.javaee.core.stereotype.Repository;
import etm.demo.webapp.javaee.domain.user.NonUniqueUserNameException;
import etm.demo.webapp.javaee.domain.user.User;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;

@Repository
public class UserRepository
implements Serializable {
    private Map<String, User> users;
    private int userId = 1;

    public User findUser(String username, String password) {
        try {
            Thread.sleep((long)(Math.random() * 2.0));
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        User user = (User)this.users.get(username);
        if (user != null && user.getPassword().equals(password)) {
            return user;
        }
        return null;
    }

    public User create(User user) {
        if (user.getUserName().startsWith("TESTUSER")) {
            user.setUserId(-1);
            user.setCreateDate(new Date());
            user.setLastModifiedDate(user.getCreateDate());
            return user;
        }
        if (this.hasUserWithUsername(user.getUserName())) {
            throw new NonUniqueUserNameException(user.getUserName());
        }
        user.setUserId(this.getNextId());
        user.setCreateDate(new Date());
        user.setLastModifiedDate(user.getCreateDate());
        try {
            Thread.sleep((long)(Math.random() * 10.0));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.users.put(user.getUserName(), user);
        return user;
    }

    public boolean hasUserWithUsername(String aUsername) {
        return this.users.get(aUsername) != null;
    }

    @PostConstruct
    public void init() {
        this.users = new ConcurrentHashMap();
        User user = new User();
        user.setFirstName("John");
        user.setLastName("Doe");
        user.setUserName("foo");
        user.setPassword("bar");
        user.setEmail("john.doe@foobar.com");
        this.create(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextId() {
        UserRepository userRepository = this;
        synchronized (userRepository) {
            int id = this.userId++;
            return id;
        }
    }
}

