/*
 * Decompiled with CFR 0.152.
 */
package etm.demo.webapp.javaee.web.authentication;

import etm.demo.webapp.javaee.core.qualifier.Registered;
import etm.demo.webapp.javaee.domain.user.User;
import etm.demo.webapp.javaee.domain.user.UserManagementService;
import etm.demo.webapp.javaee.web.core.Outcome;
import java.io.Serializable;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.NotNull;

@Named
@SessionScoped
public class AuthenticationBean
implements Serializable {
    @Inject
    private UserManagementService service;
    private String username;
    private String password;
    private User user;

    @Produces
    @Named(value="currentUser")
    @RequestScoped
    public User getCurrentUser() {
        return this.user;
    }

    public Outcome authenticate() {
        User authenticated = this.service.authenticate(this.username, this.password);
        if (authenticated != null) {
            this.user = authenticated;
            this.password = null;
            return Outcome.SUCCESS;
        }
        return Outcome.FAILURE;
    }

    @NotNull
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String aPassword) {
        this.password = aPassword;
    }

    @NotNull
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String aUsername) {
        this.username = aUsername;
    }

    public void onNewUser(@Observes @Registered User newUser) {
        this.user = newUser;
        this.username = this.user.getUserName();
    }
}

