/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.aop;

import etm.contrib.aop.resources.BarService;
import etm.contrib.aop.resources.FooService;
import etm.contrib.aop.resources.YaddaService;
import etm.core.aggregation.Aggregate;
import etm.core.monitor.EtmMonitor;
import etm.core.renderer.MeasurementRenderer;
import java.util.Map;
import junit.framework.TestCase;

public abstract class AopTestBase
extends TestCase {
    protected EtmMonitor etmMonitor;
    protected YaddaService yaddaService;
    protected BarService barService;
    protected FooService fooService;
    protected static final int MEASUREMENTS = 10;

    public void testMethodCallInterceptor() throws Exception {
        int i;
        for (i = 10; i > 0; --i) {
            this.yaddaService.doYadda();
            this.yaddaService.doYaddaYadda();
        }
        for (i = 10; i > 0; --i) {
            this.barService.doBar();
            this.barService.doBarBar();
        }
        for (i = 10; i > 0; --i) {
            this.fooService.doFoo();
            this.fooService.doFooFoo();
        }
        this.etmMonitor.render(new MeasurementRenderer(){

            public void render(Map points) {
                TestCase.assertTrue((String)"No measurement result found.", (points.size() > 0 ? 1 : 0) != 0);
                Aggregate topLevelBar = (Aggregate)points.get("BarService::doBar");
                TestCase.assertTrue((topLevelBar.getTotal() > 0.0 ? 1 : 0) != 0);
                TestCase.assertTrue((topLevelBar.getMin() > 0.0 ? 1 : 0) != 0);
                TestCase.assertTrue((topLevelBar.getMax() > 0.0 ? 1 : 0) != 0);
                TestCase.assertTrue((topLevelBar.getMin() < topLevelBar.getMax() ? 1 : 0) != 0);
                TestCase.assertEquals((double)(topLevelBar.getAverage() * (double)topLevelBar.getMeasurements()), (double)topLevelBar.getTotal(), (double)0.001);
                TestCase.assertEquals((long)10L, (long)topLevelBar.getMeasurements());
                TestCase.assertEquals((long)10L, (long)((Aggregate)points.get("BarService::doBarBar")).getMeasurements());
                TestCase.assertEquals((long)10L, (long)((Aggregate)points.get("FooService::doFoo")).getMeasurements());
                TestCase.assertEquals((long)10L, (long)((Aggregate)points.get("FooService::doFooFoo")).getMeasurements());
                Aggregate doYadda = (Aggregate)points.get("YaddaService::doYadda");
                TestCase.assertEquals((long)10L, (long)doYadda.getMeasurements());
                TestCase.assertTrue((boolean)doYadda.hasChilds());
                TestCase.assertEquals((long)20L, (long)((Aggregate)doYadda.getChilds().get("BarService::doBar")).getMeasurements());
                Aggregate doYaddaYadda = (Aggregate)points.get("YaddaService::doYaddaYadda");
                TestCase.assertEquals((long)10L, (long)doYaddaYadda.getMeasurements());
                TestCase.assertTrue((boolean)doYaddaYadda.hasChilds());
                Aggregate doBar = (Aggregate)doYaddaYadda.getChilds().get("BarService::doBar");
                TestCase.assertEquals((long)20L, (long)doBar.getMeasurements());
                TestCase.assertTrue((boolean)doBar.hasChilds());
                TestCase.assertEquals((long)20L, (long)((Aggregate)doBar.getChilds().get("FooService::doFoo")).getMeasurements());
                Aggregate doBarBar = (Aggregate)doYaddaYadda.getChilds().get("BarService::doBarBar");
                TestCase.assertEquals((long)10L, (long)doBarBar.getMeasurements());
                TestCase.assertTrue((boolean)doBarBar.hasChilds());
                TestCase.assertEquals((long)10L, (long)((Aggregate)doBarBar.getChilds().get("FooService::doFoo")).getMeasurements());
                TestCase.assertEquals((long)10L, (long)((Aggregate)doBarBar.getChilds().get("FooService::doFooFoo")).getMeasurements());
            }
        });
    }
}

