/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.aop.aspectj;

import etm.core.monitor.EtmMonitor;
import etm.core.monitor.EtmPoint;
import org.aspectj.lang.ProceedingJoinPoint;

public class EtmMethodCallInterceptor {
    private final EtmMonitor etmMonitor;

    public EtmMethodCallInterceptor(EtmMonitor aEtmMonitor) {
        this.etmMonitor = aEtmMonitor;
    }

    public Object invoke(ProceedingJoinPoint jp) throws Throwable {
        EtmPoint etmPoint = this.etmMonitor.createPoint(this.calculateName(jp));
        try {
            Object object = jp.proceed();
            return object;
        }
        catch (Throwable t) {
            this.alterNamePostException(etmPoint, t);
            throw t;
        }
        finally {
            etmPoint.collect();
        }
    }

    protected String calculateName(ProceedingJoinPoint jp) {
        Object target = jp.getTarget();
        String name = jp.getSignature().getName();
        return this.calculateShortName(target.getClass()) + "::" + name;
    }

    protected void alterNamePostException(EtmPoint aEtmPoint, Throwable t) {
        aEtmPoint.alterName(aEtmPoint.getName() + " [" + this.calculateShortName(t.getClass()) + "]");
    }

    protected String calculateShortName(Class clazz) {
        String name = clazz.getName();
        int beginIndex = name.lastIndexOf(46);
        if (beginIndex > 0) {
            return name.substring(beginIndex + 1);
        }
        return name;
    }
}

