/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.console.util;

import etm.contrib.console.ConsoleRequest;
import etm.contrib.console.ConsoleResponse;
import etm.contrib.console.util.ConsoleRenderer;
import etm.contrib.util.ExecutionAggregateComparator;
import etm.core.aggregation.Aggregate;
import etm.core.monitor.EtmException;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;

public class DetailResultRenderer
extends ConsoleRenderer {
    protected static final String ENCODING = "UTF-8";
    private String etmPointName;

    public DetailResultRenderer(ConsoleRequest aRequest, ConsoleResponse aResponse, ExecutionAggregateComparator aComparator, String aEtmPointName) {
        super(aRequest, aResponse, aComparator);
        this.etmPointName = aEtmPointName;
    }

    public void render(Map points) {
        Aggregate point = (Aggregate)points.get(this.etmPointName);
        try {
            this.writeDetailHtmlHead(this.etmPointName);
            this.response.write("<!-- Begin results -->");
            this.response.write("<table>\n");
            this.writeTableHeader();
            if (point == null) {
                this.response.write(" <tr><td colspan=\"6\">No measurement results available.</td></tr>\n".toCharArray());
            } else {
                ConsoleRenderer.SortedExecutionGraph graphSorted = new ConsoleRenderer.SortedExecutionGraph(point, this.comparator);
                this.response.write(" <tr>\n");
                this.response.write("  <td>");
                this.writeName(graphSorted, 0);
                this.response.write("</td>\n");
                this.response.write("  <td>");
                this.writeMeasurements(graphSorted, 0);
                this.response.write("</td>\n");
                this.response.write("  <td>");
                this.writeAverage(graphSorted, 0);
                this.response.write("</td>\n");
                this.response.write("  <td>");
                this.writeMin(graphSorted, 0);
                this.response.write("</td>\n");
                this.response.write("  <td>");
                this.writeMax(graphSorted, 0);
                this.response.write("</td>\n");
                this.response.write("  <td>");
                this.writeTotals(graphSorted, 0);
                this.response.write("</td>\n");
                this.response.write(" </tr>\n");
            }
            this.response.write(FOOTER);
            this.response.write("</table>\n");
            this.response.write(" </body>\n</html>");
        }
        catch (IOException e) {
            throw new EtmException("Unable to write to writer: " + e);
        }
    }

    protected void writeTableHeader() throws IOException {
        this.response.write(" <tr>\n");
        this.response.write("  <th width=\"200\" ");
        if (1 == this.comparator.getType()) {
            if (this.comparator.isDescending()) {
                this.response.write("class=\"descending\"><a href=\"?sort=name&amp;order=asc&amp;point=" + URLEncoder.encode(this.etmPointName, ENCODING) + "\">Measurement Point</a>");
            } else {
                this.response.write("class=\"ascending\"><a href=\"?sort=name&amp;order=desc&amp;point=" + URLEncoder.encode(this.etmPointName, ENCODING) + "\">Measurement Point</a>");
            }
        } else {
            this.response.write("><a href=\"?sort=name&amp;order=asc&amp;point=" + URLEncoder.encode(this.etmPointName, ENCODING) + "\">Measurement Point</a>");
        }
        this.response.write("</th>\n");
        this.response.write("  <th width=\"30\" ");
        if (2 == this.comparator.getType()) {
            if (this.comparator.isDescending()) {
                this.response.write("class=\"descending\"><a href=\"?sort=executions&amp;order=asc&amp;point=" + URLEncoder.encode(this.etmPointName, ENCODING) + "\">#</a>");
            } else {
                this.response.write("class=\"ascending\"><a href=\"?sort=executions&amp;order=desc&amp;point=" + URLEncoder.encode(this.etmPointName, ENCODING) + "\">#</a>");
            }
        } else {
            this.response.write("><a href=\"?sort=executions&amp;order=desc&amp;point=" + URLEncoder.encode(this.etmPointName, ENCODING) + "\">#</a> ");
        }
        this.response.write("</th>\n");
        this.response.write("  <th width=\"80\" ");
        if (3 == this.comparator.getType()) {
            if (this.comparator.isDescending()) {
                this.response.write("class=\"descending\"><a href=\"?sort=average&amp;order=asc&amp;point=" + URLEncoder.encode(this.etmPointName, ENCODING) + "\">Average</a>");
            } else {
                this.response.write("class=\"ascending\"><a href=\"?sort=average&amp;order=desc&amp;point=" + URLEncoder.encode(this.etmPointName, ENCODING) + "\">Average</a>");
            }
        } else {
            this.response.write("><a href=\"?sort=average&amp;order=desc&amp;point=" + URLEncoder.encode(this.etmPointName, ENCODING) + "\">Average</a> ");
        }
        this.response.write("</th>\n");
        this.response.write("  <th width=\"80\" ");
        if (4 == this.comparator.getType()) {
            if (this.comparator.isDescending()) {
                this.response.write("class=\"descending\"><a href=\"?sort=min&amp;order=asc&amp;point=" + URLEncoder.encode(this.etmPointName, ENCODING) + "\">Min</a>");
            } else {
                this.response.write("class=\"ascending\"><a href=\"?sort=min&amp;order=desc&amp;point=" + URLEncoder.encode(this.etmPointName, ENCODING) + "\">Min</a>");
            }
        } else {
            this.response.write("><a href=\"?sort=min&amp;order=desc&amp;point=" + URLEncoder.encode(this.etmPointName, ENCODING) + "\">Min</a> ");
        }
        this.response.write("</th>\n");
        this.response.write("  <th width=\"80\" ");
        if (5 == this.comparator.getType()) {
            if (this.comparator.isDescending()) {
                this.response.write("class=\"descending\"><a href=\"?sort=max&amp;order=asc&amp;point=" + URLEncoder.encode(this.etmPointName, ENCODING) + "\">Max</a>");
            } else {
                this.response.write("class=\"ascending\"><a href=\"?sort=max&amp;order=desc&amp;point=" + URLEncoder.encode(this.etmPointName, ENCODING) + "\">Max</a>");
            }
        } else {
            this.response.write("><a href=\"?sort=max&amp;order=desc&amp;point=" + URLEncoder.encode(this.etmPointName, ENCODING) + "\">Max</a>");
        }
        this.response.write("</th>\n");
        this.response.write("  <th width=\"80\" ");
        if (6 == this.comparator.getType()) {
            if (this.comparator.isDescending()) {
                this.response.write("class=\"descending\"><a href=\"?sort=total&amp;order=asc&amp;point=" + URLEncoder.encode(this.etmPointName, ENCODING) + "\">Total</a>");
            } else {
                this.response.write("class=\"ascending\"><a href=\"?sort=total&amp;order=desc&amp;point=" + URLEncoder.encode(this.etmPointName, ENCODING) + "\">Total</a>");
            }
        } else {
            this.response.write("><a href=\"?sort=total&amp;order=desc&amp;point=" + URLEncoder.encode(this.etmPointName, ENCODING) + "\">Total</a> ");
        }
        this.response.write("</th>\n");
        this.response.write(" </tr>\n");
    }
}

