/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.console;

import etm.contrib.console.ConsoleAction;
import etm.contrib.console.ConsoleException;
import etm.contrib.console.actions.ActionRegistry;
import etm.contrib.console.actions.StatusCodeAction;
import etm.contrib.console.standalone.StandaloneConsoleRequest;
import etm.contrib.console.standalone.StandaloneConsoleResponse;
import etm.contrib.console.util.ConsoleUtil;
import etm.contrib.console.util.ResourceAccessor;
import etm.core.monitor.EtmMonitor;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.Stack;

public class HttpConsoleServer {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final LogAdapter LOG = Log.getLog((Class)HttpConsoleServer.class);
    public static final int DEFAULT_LISTEN_PORT = 40000;
    private static final int DEFAULT_WORKER_SIZE = 2;
    protected EtmMonitor etmMonitor;
    private int listenPort = 40000;
    private int workerSize = 2;
    private boolean expanded = false;
    private ActionRegistry actionRegistry;
    private Stack workers;
    private ListenerThread listenerThread;
    private ConsoleAction error400 = new StatusCodeAction(400, "Bad request");
    private ConsoleAction error404 = new StatusCodeAction(404, "File not found");
    private ConsoleAction error500 = new StatusCodeAction(500, "Internal server error");

    public HttpConsoleServer(EtmMonitor aEtmMonitor) {
        this.etmMonitor = aEtmMonitor;
    }

    public void setListenPort(int aListenPort) {
        this.listenPort = aListenPort;
    }

    public void setExpanded(boolean aExpanded) {
        this.expanded = aExpanded;
    }

    public void setWorkerSize(int aWorkerSize) {
        if (this.workerSize < 2) {
            throw new IllegalArgumentException("Worker size has to be higher than two.");
        }
        this.workerSize = aWorkerSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.etmMonitor == null) {
            throw new IllegalStateException("Missing EtmMonitor reference.");
        }
        this.actionRegistry = new ActionRegistry(new ResourceAccessor(), this.expanded);
        HttpConsoleServer httpConsoleServer = this;
        synchronized (httpConsoleServer) {
            this.workers = new Stack();
            for (int i = 0; i < this.workerSize; ++i) {
                ConsoleWorker item = new ConsoleWorker("JETM HTTP Console Worker - " + (i + 1));
                item.setDaemon(true);
                item.start();
                this.workers.push(item);
            }
        }
        try {
            ServerSocket socket = new ServerSocket(this.listenPort);
            this.listenerThread = new ListenerThread(socket);
            this.listenerThread.start();
            LOG.info("Started JETM console server listening at " + socket.toString());
        }
        catch (IOException e) {
            throw new ConsoleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.listenerThread.shutdown();
        HttpConsoleServer httpConsoleServer = this;
        synchronized (httpConsoleServer) {
            for (int i = 0; i < this.workers.size(); ++i) {
                ConsoleWorker worker = (ConsoleWorker)this.workers.get(i);
                worker.shouldStop();
            }
            this.workers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConsoleWorker getWorker() {
        HttpConsoleServer httpConsoleServer = this;
        synchronized (httpConsoleServer) {
            if (this.workers.size() > 0) {
                return (ConsoleWorker)this.workers.pop();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnWorker(ConsoleWorker aConsoleWorker) {
        HttpConsoleServer httpConsoleServer = this;
        synchronized (httpConsoleServer) {
            this.workers.push(aConsoleWorker);
        }
    }

    protected int getListenPort() {
        return this.listenPort;
    }

    protected int getWorkerSize() {
        return this.workerSize;
    }

    protected boolean isExpanded() {
        return this.expanded;
    }

    class ConsoleWorker
    extends Thread {
        private Socket clientSocket;
        private boolean shouldRun;

        public ConsoleWorker() {
            this.shouldRun = true;
        }

        public ConsoleWorker(String workerName) {
            super(workerName);
            this.shouldRun = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setClientSocket(Socket aClientSocket) {
            this.clientSocket = aClientSocket;
            ConsoleWorker consoleWorker = this;
            synchronized (consoleWorker) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shouldStop() {
            this.shouldRun = false;
            ConsoleWorker consoleWorker = this;
            synchronized (consoleWorker) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (this.shouldRun) {
                try {
                    ConsoleWorker consoleWorker = this;
                    synchronized (consoleWorker) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!this.shouldRun) continue;
                    }
                    this.process(this.clientSocket);
                    continue;
                }
                catch (InterruptedIOException e) {
                    continue;
                }
                catch (Exception e) {
                    LOG.warn("Error processing HTTP request", (Throwable)e);
                    continue;
                }
                finally {
                    HttpConsoleServer.this.returnWorker(this);
                    continue;
                }
                break;
            }
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void process(Socket aClientSocket) throws IOException {
            BufferedInputStream inputStream = null;
            try {
                aClientSocket.setSoTimeout(15000);
                inputStream = new BufferedInputStream(aClientSocket.getInputStream());
                byte[] temp = new byte[3192];
                int i = 0;
                while (i < temp.length) {
                    int r = inputStream.read(temp, i, temp.length - i);
                    if (r == -1) {
                        return;
                    }
                    for (int j = i; j < i + r; ++j) {
                        if (temp[j] != 13 && temp[j] != 10) continue;
                        int endOfLine = i + j;
                        BufferedOutputStream out = new BufferedOutputStream(aClientSocket.getOutputStream());
                        this.process(out, temp, endOfLine);
                        out.flush();
                        out.close();
                        return;
                    }
                    i += r;
                }
                return;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {}
                }
                try {
                    aClientSocket.close();
                }
                catch (IOException e) {}
            }
        }

        protected void process(OutputStream out, byte[] aTemp, int endOfLine) throws IOException {
            StandaloneConsoleRequest consoleRequest = new StandaloneConsoleRequest(HttpConsoleServer.this.etmMonitor);
            ConsoleAction action = HttpConsoleServer.this.error400;
            try {
                if (endOfLine >= 5 && aTemp[0] == 71 && aTemp[1] == 69 && aTemp[2] == 84) {
                    int endOfRequestString = 0;
                    int parameterStart = 0;
                    for (int i = 4; i < endOfLine; ++i) {
                        if (aTemp[i] == 32) {
                            endOfRequestString = i;
                            break;
                        }
                        if (aTemp[i] != 63 || parameterStart != 0) continue;
                        parameterStart = i;
                    }
                    if (endOfRequestString > 0) {
                        String requestName;
                        if (parameterStart > 0) {
                            requestName = new String(aTemp, 4, parameterStart - 4, HttpConsoleServer.DEFAULT_ENCODING);
                            Map parameters = ConsoleUtil.extractRequestParameters(aTemp, parameterStart, endOfRequestString);
                            consoleRequest.setRequestParameters(parameters);
                        } else {
                            requestName = new String(aTemp, 4, endOfRequestString - 4, HttpConsoleServer.DEFAULT_ENCODING);
                        }
                        action = HttpConsoleServer.this.actionRegistry.getAction(requestName);
                        if (action == null) {
                            action = HttpConsoleServer.this.error404;
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Error processing HTTP request", (Throwable)e);
                action = HttpConsoleServer.this.error500;
            }
            StandaloneConsoleResponse consoleResponse = new StandaloneConsoleResponse(out);
            LOG.debug("Processing " + action.getClass());
            action.execute(consoleRequest, consoleResponse);
            consoleResponse.flush();
        }
    }

    class ListenerThread
    extends Thread {
        private boolean shouldRun;
        private ServerSocket socket;

        public ListenerThread(ServerSocket aSocket) {
            super("JETM HTTP Console Listener - Port " + HttpConsoleServer.this.listenPort);
            this.shouldRun = true;
            this.socket = aSocket;
        }

        public void run() {
            while (this.shouldRun) {
                try {
                    Socket clientSocket = this.socket.accept();
                    ConsoleWorker worker = HttpConsoleServer.this.getWorker();
                    if (worker != null) {
                        worker.setClientSocket(clientSocket);
                        continue;
                    }
                    new ConsoleWorker().process(clientSocket);
                }
                catch (Exception e) {
                    if (this.shouldRun) {
                        LOG.warn("Error processing HTTP request", (Throwable)e);
                        continue;
                    }
                    LOG.debug("Error during shutdown" + e.toString());
                }
            }
        }

        public void shutdown() {
            this.shouldRun = false;
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.socket = null;
        }
    }
}

