/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.jee.jsf;

import etm.core.configuration.EtmManager;
import etm.core.monitor.EtmPoint;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewDeclarationLanguage;

public class DelegatingEtmViewHandler
extends ViewHandler {
    private static final LogAdapter LOG = Log.getLog(DelegatingEtmViewHandler.class);
    private ViewHandler delegate;

    public DelegatingEtmViewHandler(ViewHandler aDelegate) {
        this.delegate = aDelegate;
        LOG.debug("Activated " + ((Object)((Object)this)).getClass().getSimpleName() + ".");
    }

    public void addProtectedView(String urlPattern) {
        this.delegate.addProtectedView(urlPattern);
    }

    public String calculateCharacterEncoding(FacesContext context) {
        return this.delegate.calculateCharacterEncoding(context);
    }

    public String deriveLogicalViewId(FacesContext context, String rawViewId) {
        return this.delegate.deriveLogicalViewId(context, rawViewId);
    }

    public String deriveViewId(FacesContext context, String rawViewId) {
        return this.delegate.deriveViewId(context, rawViewId);
    }

    public String getBookmarkableURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        return this.delegate.getBookmarkableURL(context, viewId, parameters, includeViewParams);
    }

    public Set<String> getProtectedViewsUnmodifiable() {
        return this.delegate.getProtectedViewsUnmodifiable();
    }

    public String getRedirectURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        return this.delegate.getRedirectURL(context, viewId, parameters, includeViewParams);
    }

    public ViewDeclarationLanguage getViewDeclarationLanguage(FacesContext context, String viewId) {
        return this.delegate.getViewDeclarationLanguage(context, viewId);
    }

    public void initView(FacesContext context) throws FacesException {
        this.delegate.initView(context);
    }

    public boolean removeProtectedView(String urlPattern) {
        return this.delegate.removeProtectedView(urlPattern);
    }

    public Locale calculateLocale(FacesContext aFacesContext) {
        return this.delegate.calculateLocale(aFacesContext);
    }

    public String calculateRenderKitId(FacesContext aFacesContext) {
        return this.delegate.calculateRenderKitId(aFacesContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot createView(FacesContext aFacesContext, String s) {
        EtmPoint point = EtmManager.getEtmMonitor().createPoint("Create view " + s);
        try {
            UIViewRoot uIViewRoot = this.delegate.createView(aFacesContext, s);
            return uIViewRoot;
        }
        finally {
            point.collect();
        }
    }

    public String getActionURL(FacesContext aFacesContext, String s) {
        return this.delegate.getActionURL(aFacesContext, s);
    }

    public String getResourceURL(FacesContext aFacesContext, String s) {
        return this.delegate.getResourceURL(aFacesContext, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderView(FacesContext aFacesContext, UIViewRoot aUIViewRoot) throws IOException, FacesException {
        EtmPoint point = EtmManager.getEtmMonitor().createPoint("Render view " + aUIViewRoot.getViewId());
        try {
            this.delegate.renderView(aFacesContext, aUIViewRoot);
        }
        finally {
            point.collect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext aFacesContext, String s) {
        EtmPoint point = EtmManager.getEtmMonitor().createPoint("Restore view " + s);
        try {
            UIViewRoot uIViewRoot = this.delegate.restoreView(aFacesContext, s);
            return uIViewRoot;
        }
        finally {
            point.collect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeState(FacesContext aFacesContext) throws IOException {
        EtmPoint point = EtmManager.getEtmMonitor().createPoint("Write state");
        try {
            this.delegate.writeState(aFacesContext);
        }
        finally {
            point.collect();
        }
    }
}

