/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.rrd.rrd4j;

import etm.contrib.rrd.core.AbstractRrdExecutionWriter;
import etm.core.monitor.EtmException;
import etm.core.monitor.EtmPoint;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import java.io.IOException;
import java.util.Date;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.Sample;
import org.rrd4j.core.Util;

public class Rrd4jAggregationWriter
extends AbstractRrdExecutionWriter {
    private static final LogAdapter LOG = Log.getLog(AbstractRrdExecutionWriter.class);
    private RrdDb db;
    private boolean transactionsEnabled;
    private boolean minEnabled;
    private boolean maxEnabled;
    private boolean averageEnabled;

    public Rrd4jAggregationWriter(RrdDb aDb) {
        super(Rrd4jAggregationWriter.extractLastTimestamp(aDb), Rrd4jAggregationWriter.extractStep(aDb));
        this.transactionsEnabled = this.validateDataSource(aDb, "transactions!");
        this.minEnabled = this.validateDataSource(aDb, "min");
        this.maxEnabled = this.validateDataSource(aDb, "max");
        this.averageEnabled = this.validateDataSource(aDb, "average");
        if (!(this.transactionsEnabled || this.minEnabled || this.maxEnabled || this.averageEnabled)) {
            throw new EtmException("Invalid datasource. One of the datasources 'transactions', 'min', 'max' or 'average' should exist in " + aDb.getPath() + ".");
        }
        this.db = aDb;
        LOG.debug("Using Rrd4j destination " + aDb.getPath() + " starting at " + new Date(this.startInterval * 1000L) + " with step " + this.increment + " seconds.");
    }

    public void onBegin() {
    }

    public void onFinish() {
        this.flushStatus();
    }

    protected long calculateTimestamp(EtmPoint measurement) {
        return Util.getTimestamp((Date)new Date(measurement.getStartTimeMillis()));
    }

    protected void flushStatus() {
        if (this.transactions > 0) {
            try {
                Sample sample = this.db.createSample(this.endInterval);
                if (this.transactionsEnabled) {
                    sample.setValue("transactions!", (double)this.transactions);
                }
                if (this.minEnabled) {
                    sample.setValue("min", this.min);
                }
                if (this.maxEnabled) {
                    sample.setValue("max", this.max);
                }
                if (this.averageEnabled) {
                    double value = this.total / (double)this.transactions;
                    sample.setValue("average", value);
                }
                sample.update();
            }
            catch (IOException e) {
                throw new EtmException((Throwable)e);
            }
        }
    }

    protected boolean validateDataSource(RrdDb aDb, String name) {
        try {
            return aDb.getDatasource(name) != null;
        }
        catch (IOException e) {
            throw new EtmException((Throwable)e);
        }
    }

    private static long extractStep(RrdDb aDb) {
        try {
            return aDb.getRrdDef().getStep();
        }
        catch (IOException e) {
            throw new EtmException((Throwable)e);
        }
    }

    private static long extractLastTimestamp(RrdDb aDb) {
        try {
            return aDb.getLastUpdateTime();
        }
        catch (IOException e) {
            throw new EtmException((Throwable)e);
        }
    }
}

