/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.web;

import etm.contrib.integration.web.HttpRequestPerformanceFilter;
import etm.core.aggregation.Aggregate;
import etm.core.configuration.EtmManager;
import etm.core.monitor.EtmMonitor;
import etm.core.renderer.MeasurementRenderer;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.apache.log4j.BasicConfigurator;

public class HttpRequestPerformanceFilterTest
extends TestCase {
    protected Filter filter;
    protected EtmMonitor etmMonitor;

    public void setUp() throws Exception {
        EtmManager.reset();
        BasicConfigurator.configure();
        this.filter = new HttpRequestPerformanceFilter();
        this.filter.init(null);
        this.etmMonitor = EtmManager.getEtmMonitor();
        this.etmMonitor.start();
    }

    public void tearDown() {
        this.etmMonitor.stop();
    }

    public void testHttpRequestMonitoring() throws Exception {
        this.filter.doFilter(this.getHttpServletRequest(), null, this.getFilterChain());
        this.etmMonitor.render(new MeasurementRenderer(){

            public void render(Map points) {
                String key = "POST request /test/testrequest";
                TestCase.assertTrue((boolean)points.containsKey(key));
                Aggregate aggregate = (Aggregate)points.get(key);
                TestCase.assertEquals((long)1L, (long)aggregate.getMeasurements());
                TestCase.assertEquals((double)15.0, (double)aggregate.getMin(), (double)0.0);
            }
        });
    }

    protected FilterChain getFilterChain() {
        return new FilterChain(){

            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
                try {
                    Thread.sleep(15L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
    }

    private ServletRequest getHttpServletRequest() throws Exception {
        return (ServletRequest)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{HttpServletRequest.class}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("toString")) {
                    return (class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = HttpRequestPerformanceFilterTest.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest).getName();
                }
                if (method.getName().equals("getRequestURI")) {
                    return "/test/testrequest";
                }
                if (method.getName().equals("getMethod")) {
                    return "POST";
                }
                return null;
            }
        });
    }
}

