/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.archetype.domain.user;

import de.openknowledge.archetype.domain.user.EncryptedPassword;
import de.openknowledge.archetype.domain.user.PlainTextPassword;
import de.openknowledge.archetype.domain.user.Salt;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class EncryptionService
implements Serializable {
    public static final String CHARSET = "UTF-8";
    private static final String CRYPTOGRAPHY_ALGORITHM = "SHA-1";

    public EncryptedPassword encrypt(PlainTextPassword plainTextPassword) {
        Salt salt = Salt.createSalt();
        return this.encrypt(plainTextPassword, salt);
    }

    public EncryptedPassword encrypt(PlainTextPassword plainTextPassword, Salt salt) {
        try {
            MessageDigest digest = MessageDigest.getInstance(CRYPTOGRAPHY_ALGORITHM);
            byte[] crypted = digest.digest(this.addSaltToPlainTextPassword(plainTextPassword, salt));
            String encryptedPassword = new String(crypted, CHARSET);
            return new EncryptedPassword(encryptedPassword, salt);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private byte[] addSaltToPlainTextPassword(PlainTextPassword plainTextPassword, Salt salt) throws UnsupportedEncodingException {
        return ((String)plainTextPassword.getValue() + (String)salt.getValue()).getBytes(CHARSET);
    }
}

