/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.archetype.domain.user;

import de.openknowledge.archetype.domain.user.EncryptedPassword;
import de.openknowledge.archetype.domain.user.EncryptionService;
import de.openknowledge.archetype.domain.user.PlainTextPassword;
import de.openknowledge.archetype.domain.user.Salt;
import de.openknowledge.archetype.domain.user.User;
import de.openknowledge.archetype.domain.user.UserNotFoundException;
import de.openknowledge.archetype.domain.user.UserRepository;
import de.openknowledge.archetype.domain.user.Username;
import java.io.Serializable;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;

@Named
@ApplicationScoped
public class AuthenticationService
implements Serializable {
    @Inject
    private UserRepository userRepository;
    @Inject
    private EncryptionService encryptionService;

    public boolean authenticate(Username userame, PlainTextPassword plainTextPassword) {
        User user;
        try {
            user = this.userRepository.findUser(userame);
        }
        catch (UserNotFoundException e) {
            return false;
        }
        EncryptedPassword enteredPassword = this.encryptionService.encrypt(plainTextPassword, new Salt(user.getPassword()));
        return user.getPassword().equals(enteredPassword);
    }
}

