/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.archetype.domain.user;

import de.openknowledge.archetype.domain.AbstractValueObject;
import de.openknowledge.archetype.domain.user.EncryptedPassword;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.Validate;

public class Salt
extends AbstractValueObject<String> {
    public static final int SALT_LENGTH = 20;

    public Salt(String salt) {
        super(Salt.checkSaltLength(salt));
    }

    protected Salt(EncryptedPassword encryptedPassword) {
        super(((String)encryptedPassword.getValue()).substring(((String)encryptedPassword.getValue()).length() - 20));
    }

    public static Salt createSalt() {
        return new Salt(RandomStringUtils.randomAscii((int)20));
    }

    private static String checkSaltLength(String salt) {
        Validate.isTrue((((String)Validate.notNull((Object)salt, (String)"salt may not be null", (Object[])new Object[0])).length() == 20 ? 1 : 0) != 0, (String)"salt must have a length of 20", (Object[])new Object[0]);
        return salt;
    }
}

