#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/*
 *
 * ${groupId}.presentation.common.phaselistener.DebugPhaseListener.java
 *
 *
 * This document contains trade secret data which is the property of OpenKnowledge GmbH. Information contained herein
 * may not be used, copied or disclosed in whole or part except as permitted by written agreement from OpenKnowledge
 * GmbH.
 *
 * Copyright (C) 2013 open knowledge GmbH / Oldenburg / Germany
 */
package ${groupId}.presentation.common.phaselistener;

import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;

import org.apache.log4j.Logger;

/**
 * Phase listener that logs every step of the jsf lifecycle.
 */
public class DebugPhaseListener
    implements PhaseListener {

  private static final Logger LOGGER = Logger.getLogger(DebugPhaseListener.class);

  @Override
  public void afterPhase(final PhaseEvent event) {

    if (LOGGER.isDebugEnabled()) {
      LOGGER.debug("After phase: " + event.getPhaseId());
    }
  }

  @Override
  public void beforePhase(final PhaseEvent event) {

    if (LOGGER.isDebugEnabled()) {
      LOGGER.debug("Before phase: " + event.getPhaseId());
    }
  }

  @Override
  public PhaseId getPhaseId() {

    return PhaseId.ANY_PHASE;
  }
}
