#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/*
 *
 * ${groupId}.core.persistence.PersistenceUnit.java
 *
 *
 * This document contains trade secret data which is the property of OpenKnowledge GmbH. Information contained herein
 * may not be used, copied or disclosed in whole or part except as permitted by written agreement from OpenKnowledge
 * GmbH.
 *
 * Copyright (C) 2013 open knowledge GmbH / Oldenburg / Germany
 */
package ${groupId}.core.persistence;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;

/**
 * Persistence Unit that provides {@link EntityManagerFactory} and {@link EntityManager}.
 */
@ApplicationScoped
public class PersistenceContext {

  public static final String PERSISTENCE_UNIT = "local";

  @PersistenceUnit(name = PERSISTENCE_UNIT)
  private EntityManagerFactory entityManagerFactory;

  public static void closeEntityManagerFactory(@Disposes EntityManagerFactory factory) {
    factory.close();
  }

  @Produces
  @ApplicationScoped
  public EntityManagerFactory getEntityManagerFactory() {
    return entityManagerFactory;
  }

  @Produces
  @RequestScoped
  public EntityManager createEntityManager(EntityManagerFactory factory) {
    return factory.createEntityManager();
  }

  public void closeEntityManager(@Disposes EntityManager entityManager) {
    entityManager.close();
  }
}
