#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${groupId}.testdata;

import javax.ejb.Singleton;
import javax.inject.Inject;
import javax.persistence.EntityManager;

import ${groupId}.core.transaction.Transactional;
import ${groupId}.domain.user.EncryptionService;
import ${groupId}.domain.user.PlainTextPassword;
import ${groupId}.domain.user.User;
import ${groupId}.domain.user.Username;


/**
 * Created by pierre.liebsch on 30.09.13.
 */

@Singleton
public class TestData {

  private static final String TEST = "test";
  @Inject
  private EntityManager entityManager;
  @Inject
  private EncryptionService encryptionService;

  @Transactional
  public void create() {

    User user = new User(new Username(TEST), encryptionService.encrypt(new PlainTextPassword(TEST)));
    entityManager.persist(user);

  }

}
