#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${groupId}.domain.user;

import java.io.Serializable;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;

/**
 * Created by pierre.liebsch on 08.10.13.
 */
@Named
@ApplicationScoped
public class AuthenticationService implements Serializable {

  @Inject
  private UserRepository userRepository;
  @Inject
  private EncryptionService encryptionService;

  public boolean authenticate(Username userame, PlainTextPassword plainTextPassword) {
    User user;

    try {
      user = userRepository.findUser(userame);
    } catch (UserNotFoundException e) {
      return false;
    }

    EncryptedPassword enteredPassword = encryptionService.encrypt(plainTextPassword, new Salt(user.getPassword()));
    return user.getPassword().equals(enteredPassword);
  }


}
