#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/*
 *
 * ${groupId}.core.transaction.TransactionInterceptor.java
 *
 *
 * This document contains trade secret data which is the property of OpenKnowledge GmbH. Information contained herein
 * may not be used, copied or disclosed in whole or part except as permitted by written agreement from OpenKnowledge
 * GmbH.
 *
 * Copyright (C) 2013 open knowledge GmbH / Oldenburg / Germany
 */
package ${groupId}.core.transaction;

import java.io.Serializable;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.transaction.Status;
import javax.transaction.UserTransaction;

/**
 * Basic transactional interceptor.
 */
@Transactional
@Interceptor
public class TransactionInterceptor implements Serializable {

  @Inject
  private UserTransaction utx;

  @AroundInvoke
  public Object applyTransaction(InvocationContext ic) throws Exception {
    Transactional tx = ic.getMethod().getAnnotation(Transactional.class);

    if (tx.value() == TransactionalType.REQUIRED) {

      boolean startedTransaction = false;
      if (utx.getStatus() != Status.STATUS_ACTIVE) {
        utx.begin();
        startedTransaction = true;
      }

      Object ret;
      try {
        ret = ic.proceed();

        if (startedTransaction) {
          utx.commit();
        }
      } catch (Exception t) {
        if (startedTransaction) {
          utx.rollback();
        }

        throw t;
      }

      return ret;
    } else if (tx.value() == TransactionalType.REQUIRES_NEW) {
      throw new UnsupportedOperationException("Not supported yet.");
    }

    return ic.proceed();

  }
}
