#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${groupId}.domain.user;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;

import org.junit.Before;
import org.junit.Test;

import ${groupId}.domain.AbstractJpaTest;

/**
 * Created by pierre.liebsch on 08.10.13.
 */
public class UserRepositoryTest extends AbstractJpaTest {

  public static final String TEST_DATA = "TEST_DATA";

  static boolean userCreated = false;
  static User testUser = new User(new Username(TEST_DATA), new EncryptedPassword(TEST_DATA, Salt.createSalt()));

  UserRepository userRepository;


  @Before
  public void persistUser() {
    if (!userCreated) {
      getEntityManager().getTransaction().begin();
      getEntityManager().persist(testUser);
      getEntityManager().getTransaction().commit();
      userCreated = true;
    }
  }

  @Before
  public void initUserRepository() {
    userRepository = new UserRepository();
    userRepository.entityManager = getEntityManager();
  }

  @Test
  public void successfulFound() throws UserNotFoundException {

    User foundedUser = userRepository.findUser(testUser.getName());

    assertThat(testUser.getName(), is(foundedUser.getName()));
    assertThat(testUser.getPassword(), is(foundedUser.getPassword()));

  }

  @Test(expected = UserNotFoundException.class)
  public void userNotFound() throws UserNotFoundException {

    Username username = new Username(TEST_DATA + TEST_DATA);

    userRepository.findUser(username);

  }


}
