#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/*
 *
 * ${package}.controller.AuthenticationController
 *
 *
 * This document contains trade secret data which is the property of OpenKnowledge GmbH. Information contained herein
 * may not be used, copied or disclosed in whole or part except as permitted by written agreement from OpenKnowledge
 * GmbH.
 *
 * Copyright (C) 2013 open knowledge GmbH / Oldenburg / Germany
 */
package ${package}.controller;

import java.io.Serializable;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;

import ${package}.domain.user.AuthenticationService;
import ${package}.domain.user.PlainTextPassword;
import ${package}.domain.user.Username;

/**
 * Created by pierre.liebsch on 09.10.13.
 */
@Named
@SessionScoped
public class AuthenticationController implements Serializable {

  @Inject
  private AuthenticationService authenticationService;

  private String username;
  private String password;
  private String message = "";


  public String getUsername() {
    return username;
  }

  public void setUsername(String username) {
    this.username = username;
  }

  public String getPassword() {
    return password;
  }

  public void setPassword(String password) {
    this.password = password;
  }

  public String getMessage() {
    return message;
  }


  public void authenticate() {
    if (authenticationService.authenticate(new Username(username), new PlainTextPassword(password))) {
      message = "Welcome, " + username;
    } else {
      message = "Username or Password wrong";
    }
  }

}
