#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/*
 *
 * ${package}.presentation.common.converter.EntityConverter.java
 *
 *
 * This document contains trade secret data which is the property of OpenKnowledge GmbH. Information contained herein
 * may not be used, copied or disclosed in whole or part except as permitted by written agreement from OpenKnowledge
 * GmbH.
 *
 * Copyright (C) 2013 open knowledge GmbH / Oldenburg / Germany
 */
package ${package}.presentation.common.converter;

import static org.apache.commons.lang3.StringUtils.isBlank;

import java.io.Serializable;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.inject.Inject;
import javax.persistence.EntityManager;

import org.apache.commons.lang3.StringUtils;

import ${package}.domain.AbstractEntity;
import ${package}.presentation.common.PublicIdGenerator;

/**
 * Abstract converter for entities.
 */
public abstract class EntityConverter<C extends AbstractEntity>
    implements Converter, Serializable {

  private final Class<C> clazz;

  @Inject
  private EntityManager entityManager;

  @Inject
  private PublicIdGenerator idGenerator;

  protected EntityConverter(final Class<C> clazz) {

    super();
    this.clazz = clazz;
  }

  @Override
  public Object getAsObject(final FacesContext context, final UIComponent component, final String value) {

    if (isBlank(value)) {
      return null;
    }

    Object entityId = idGenerator.lookup(clazz, value);
    C entity = entityManager.find(clazz, entityId);
    return entity;
  }

  @Override
  public String getAsString(final FacesContext context, final UIComponent component, final Object value) {

    if (value == null) {
      return StringUtils.EMPTY;
    }

    Long entityId = ((AbstractEntity)value).getId();
    String publicId = idGenerator.generatePublicId(clazz, entityId);
    return publicId;
  }
}
