#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.domain.user;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

/**
 * Created by pierre.liebsch on 08.10.13.
 */


@RunWith(MockitoJUnitRunner.class)
public class AuthenticationServiceTest {

  public static final String TEST_DATA = "TEST_DATA";

  @Mock
  private UserRepository userRepository;
  @Mock
  private EncryptionService encryptionService;
  @InjectMocks
  private AuthenticationService authenticationService;

  private PlainTextPassword plainTextPassword = new PlainTextPassword("plain");
  private EncryptedPassword encryptedPassword = new EncryptedPassword("encrypted", Salt.createSalt());
  private Username username = new Username("user");
  private User user = new User(username, encryptedPassword);

  @Test
  public void successfulAuthentication() throws UserNotFoundException {


    when(userRepository.findUser(username)).thenReturn(user);
    when(encryptionService.encrypt(plainTextPassword, encryptedPassword.getSalt())).thenReturn(encryptedPassword);

    assertThat(authenticationService.authenticate(username, plainTextPassword), is(true));

    verify(encryptionService).encrypt(plainTextPassword, new Salt(encryptedPassword));
  }

  @Test
  public void wrongUsername() throws UserNotFoundException {

    when(userRepository.findUser(username)).thenThrow(UserNotFoundException.class);

    assertThat(authenticationService.authenticate(username, plainTextPassword), is(false));


  }

  @Test
  public void wrongPassword() throws UserNotFoundException {

    PlainTextPassword wrongPassword = new PlainTextPassword("wrong");

    when(userRepository.findUser(username)).thenReturn(user);
    when(encryptionService.encrypt(plainTextPassword, encryptedPassword.getSalt())).thenReturn(encryptedPassword);

    assertThat(authenticationService.authenticate(username, wrongPassword), is(false));


  }

}
