#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.domain.user;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.CoreMatchers.not;
import static org.junit.Assert.assertThat;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Test;

/**
 * Created by pierre.liebsch on 22.10.13.
 */

public class EncryptionServiceTest {

  private EncryptionService encryptionService = new EncryptionService();

  private PlainTextPassword plainTextPassword = new PlainTextPassword("test");


  @Test
  public void encryptedPasswordsShouldBeRandom() {

    EncryptedPassword encryptedPasswordOne = encryptionService.encrypt(plainTextPassword);
    EncryptedPassword encryptedPasswordTwo = encryptionService.encrypt(plainTextPassword);

    assertThat(encryptedPasswordOne, is(not(encryptedPasswordTwo)));

  }

  @Test
  public void encryptedPasswordsShouldBeSameWithSameSalt() {

    EncryptedPassword encryptedPasswordOne = encryptionService.encrypt(plainTextPassword);
    Salt saltOne = new Salt(encryptedPasswordOne);
    EncryptedPassword encryptedPasswordTwo = encryptionService.encrypt(plainTextPassword, saltOne);
    Salt saltTwo = new Salt(encryptedPasswordTwo);

    assertThat(encryptedPasswordOne, is(encryptedPasswordTwo));
    assertThat(saltOne, is(saltTwo));

  }

  @Test
  public void encryptedPasswordsShouldNotBeSameWithDifferentSalt() {

    EncryptedPassword encryptedPasswordOne = encryptionService.encrypt(plainTextPassword);
    Salt generatedSalt = encryptedPasswordOne.getSalt();

    Salt differentSalt = new Salt(RandomStringUtils.random(Salt.SALT_LENGTH));
    EncryptedPassword encryptedPasswordTwo = encryptionService.encrypt(plainTextPassword, differentSalt);

    assertThat(encryptedPasswordOne, is(not(encryptedPasswordTwo)));
    assertThat(differentSalt, is(not(generatedSalt)));

  }

}
