#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.domain.user;

import javax.persistence.Embeddable;
import javax.persistence.Transient;

import ${package}.domain.AbstractValueObject;


/**
 * Created by pierre.liebsch on 30.09.13.
 */
@Embeddable
public class EncryptedPassword extends AbstractValueObject<String> implements Comparable<AbstractValueObject<String>> {

  @Transient
  private Salt salt;

  protected EncryptedPassword() {
  }

  public EncryptedPassword(String value, Salt salt) {
    super(value + salt.getValue());
  }

  public Salt getSalt() {
    if (salt == null) {
      salt = new Salt(this);
    }
    return salt;
  }


}
