#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.domain.user;


import static org.apache.commons.lang3.Validate.isTrue;
import static org.apache.commons.lang3.Validate.notNull;

import org.apache.commons.lang3.RandomStringUtils;

import ${package}.domain.AbstractValueObject;

/**
 * Created by pierre.liebsch on 24.10.13.
 */

public class Salt extends AbstractValueObject<String> {

  public static final int SALT_LENGTH = 20;

  public Salt(String salt) {

    super(checkSaltLength(salt));

  }

  protected Salt(EncryptedPassword encryptedPassword) {
    super(encryptedPassword.getValue().substring(encryptedPassword.getValue().length() - SALT_LENGTH));
  }

  public static Salt createSalt() {
    return new Salt(RandomStringUtils.randomAscii(SALT_LENGTH));
  }

  private static String checkSaltLength(String salt) {
    isTrue(notNull(salt, "salt may not be null").length() == SALT_LENGTH, "salt must have a length of " + SALT_LENGTH);
    return salt;
  }


}
