#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.domain.user;

import java.io.Serializable;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;

/**
 * Created by pierre.liebsch on 08.10.13.
 */
@Named
@ApplicationScoped
public class UserRepository implements Serializable {

  @Inject
  protected EntityManager entityManager;


  /**
   * @param username
   * @return
   */
  public User findUser(Username username) throws UserNotFoundException {

    User user;
    try {
      TypedQuery<User> query = entityManager.createNamedQuery("User.findByUsername", User.class);
      query.setParameter("username", username);
      user = query.getSingleResult();
    } catch (NoResultException e) {
      throw new UserNotFoundException(e);
    }
    return user;


  }


}
