#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.testdata;

import javax.ejb.Singleton;
import javax.inject.Inject;
import javax.persistence.EntityManager;

import ${package}.core.transaction.Transactional;
import ${package}.domain.user.EncryptionService;
import ${package}.domain.user.PlainTextPassword;
import ${package}.domain.user.User;
import ${package}.domain.user.Username;


/**
 * Created by pierre.liebsch on 30.09.13.
 */

@Singleton
public class TestData {

  private static final String TEST = "test";
  @Inject
  private EntityManager entityManager;
  @Inject
  private EncryptionService encryptionService;

  @Transactional
  public void create() {

    User user = new User(new Username(TEST), encryptionService.encrypt(new PlainTextPassword(TEST)));
    entityManager.persist(user);

  }

}
