#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${groupId}.presentation.common.converter;

import javax.faces.application.FacesMessage;
import javax.faces.convert.ConverterException;
import javax.faces.convert.FacesConverter;

import ${groupId}.domain.user.PlainTextPassword;

/**
 * Created by pierre.liebsch on 16.12.13.
 */

@FacesConverter(forClass = PlainTextPassword.class)
public class PlainTextPasswordConverter extends ValueObjectConverter<PlainTextPassword> {

  @Override
  protected PlainTextPassword createInstance(String value) {

    if (value == null || value.equals("")) {
      throw new ConverterException(new FacesMessage("Ungültiges Passwort"));
    }
    return new PlainTextPassword(value);
  }
}
