#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/*
 *
 * ${groupId}.presentation.common.phaselistener.ParameterPhaseListener.java
 *
 *
 * This document contains trade secret data which is the property of OpenKnowledge GmbH. Information contained herein
 * may not be used, copied or disclosed in whole or part except as permitted by written agreement from OpenKnowledge
 * GmbH.
 *
 * Copyright (C) 2013 open knowledge GmbH / Oldenburg / Germany
 */
package ${groupId}.presentation.common.phaselistener;

import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;

import org.apache.log4j.Logger;

/**
 * Phase listener that logs all parameter from the client.
 */
public class ParameterPhaseListener
  implements PhaseListener {

  private static final Logger LOGGER = Logger.getLogger(ParameterPhaseListener.class);

  @Override
  public void afterPhase(final PhaseEvent event) {

  }

  @Override
  public void beforePhase(final PhaseEvent event) {

    FacesContext fc = FacesContext.getCurrentInstance();
    Map<String, String> map = fc.getExternalContext().
      getRequestParameterMap();
    for (String key : map.keySet()) {
      StringBuilder param = new StringBuilder();
      param.append("Parameter: ");
      param.append(key);
      param.append(" = ");
      param.append(map.get(key));
      LOGGER.debug(param.toString());
    }
  }

  @Override
  public PhaseId getPhaseId() {

    return PhaseId.APPLY_REQUEST_VALUES;
  }
}
