#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/*
 * Copyright 2013 open knowledge GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package ${groupId}.integrationtest;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;

import org.junit.Before;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;

/**
 * @author Raffaela Ferrari
 */
public abstract class AbstractHtmlTestCase {

  private static final String ATEXTTAG = "//a[text() = '";
  private static final String ENDSQAREBRACKET = "']";
  private static final String VALUE = "value";
  private static final int DELETE_HTML_PREFIX = 4;

  private String url;

  private WebClient webClient;

  protected AbstractHtmlTestCase(String url) {
    this.url = url;
  }

  public WebClient getWebClient() {
    return webClient;
  }

  @Before
  public void createHttpSession() {
    webClient = new WebClient();

    // Wieder raus nehmen
    //webClient.setJavaScriptEnabled(${jsfPrimeFaces});
    getHtmlPage("");
  }


  public HtmlPage getHtmlPage(String name) {
    return (HtmlPage)getPage(name);
  }

  private Page getPage(String name) {
    try {
      return webClient.getPage(url + name);
    } catch (IOException e) {
      throw new AssertionError(e);
    } catch (FailingHttpStatusCodeException e) {
      throw new AssertionError();
    }
  }

  public HtmlPage login(String username, String password,
                        String usernameFieldId, String passwordFieldId, String submitButtonId) throws IOException {

    HtmlPage page = getHtmlPage("index.xhtml");

    page = (HtmlPage)page.refresh();

    DomElement input = page.getElementById(usernameFieldId);
    input.setAttribute(VALUE, username);
    input = page.getElementById(passwordFieldId);
    input.setAttribute(VALUE, password);

    HtmlSubmitInput btn = page.getHtmlElementById(submitButtonId);

    return btn.click();

  }

  public HtmlPage testLink(String page, String linkName) {
    try {
      HtmlAnchor link = (HtmlAnchor)getByXpath(getHtmlPage(page), ATEXTTAG + linkName + ENDSQAREBRACKET).iterator().next();
      HtmlPage linkPage = (HtmlPage)link.click();
      return linkPage;
    } catch (IOException e) {
      throw new AssertionError(e);
    }
  }

  public HtmlPage testLink(HtmlPage page, String linkName, int placeOfOccurence) {
    try {
      Iterator<DomNode> iterator = getByXpath(page, ATEXTTAG + linkName + ENDSQAREBRACKET).iterator();
      for (int i = 0; i < placeOfOccurence - 1; i++) {
        iterator.next();
      }
      HtmlAnchor link = (HtmlAnchor)iterator.next();
      HtmlPage linkPage = (HtmlPage)link.click();
      return linkPage;
    } catch (IOException e) {
      throw new AssertionError(e);
    }
  }

  public HtmlPage testLink(HtmlPage page, String linkName) {
    try {
      HtmlAnchor link = (HtmlAnchor)getByXpath(page, ATEXTTAG + linkName + ENDSQAREBRACKET).iterator().next();
      HtmlPage linkPage = (HtmlPage)link.click();
      return linkPage;
    } catch (IOException e) {
      throw new AssertionError(e);
    }
  }

  public HtmlPage testInputLink(HtmlPage page, String linkName) {
    try {
      HtmlInput inputLink = (HtmlInput)getByXpath(page, "//input[@name = '" + linkName + ENDSQAREBRACKET).iterator().next();
      HtmlPage inputLinkPage = (HtmlPage)inputLink.click();
      return inputLinkPage;
    } catch (IOException e) {
      throw new AssertionError(e);
    }
  }

  public HtmlPage testButton(HtmlPage page, String linkName) {
    try {
      HtmlButton buttonLink = (HtmlButton)getByXpath(page, "//button[text() = '" + linkName + ENDSQAREBRACKET).iterator().next();
      HtmlPage buttonLinkPage = (HtmlPage)buttonLink.click();
      return buttonLinkPage;
    } catch (IOException e) {
      throw new AssertionError(e);
    }
  }

  public HtmlForm getFormById(DomNode node, String id) {
    return getById(node, HtmlForm.class, id);
  }

  public HtmlInput getInputById(DomNode node, String id) {
    return getById(node, HtmlInput.class, id);
  }

  public HtmlSelect getSelectById(DomNode node, String id) {
    return getById(node, HtmlSelect.class, id);
  }

  public <T extends HtmlElement> T getById(DomNode page, Class<T> type, String id) {
    String elementName = type.getSimpleName().substring(DELETE_HTML_PREFIX).toLowerCase();
    T result = null;
    for (DomNode node : getByXpath(page, "//" + elementName + "[@id='" + id + ENDSQAREBRACKET)) {
      if (type.isInstance(node)) {
        T element = type.cast(node);
        if (result != null) {
          throw new IllegalStateException("More that one form found with id " + id);
        }
        result = element;
      }
    }
    if (result == null) {
      throw new ElementNotFoundException(elementName, "id", id);
    }
    return result;
  }

  protected List<DomNode> getByXpath(DomNode parent, String xPath) {
    return (List<DomNode>)parent.getByXPath(xPath);
  }


}
