#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/*
 *
 * ${groupId}.controller.AuthenticationController
 *
 *
 * This document contains trade secret data which is the property of OpenKnowledge GmbH. Information contained herein
 * may not be used, copied or disclosed in whole or part except as permitted by written agreement from OpenKnowledge
 * GmbH.
 *
 * Copyright (C) 2013 open knowledge GmbH / Oldenburg / Germany
 */
package ${groupId}.controller;

import java.io.Serializable;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;

import ${groupId}.domain.user.AuthenticationService;
import ${groupId}.domain.user.PlainTextPassword;
import ${groupId}.domain.user.User;
import ${groupId}.domain.user.UserNotFoundException;
import ${groupId}.domain.user.UserRepository;
import ${groupId}.domain.user.Username;
import ${groupId}.presentation.common.events.LoggedIn;

/**
 * Created by pierre.liebsch on 09.10.13.
 */

@Named
@Stateless
public class AuthenticationController implements Serializable {

  @Inject
  private FacesContext facesContext;

  @Inject
  private AuthenticationService authenticationService;

  @Inject
  @LoggedIn
  private Event<User> event;

  @Inject
  private UserRepository userRepository;

  @Inject
  private EntityManager entityManager;

  private Username username;
  private PlainTextPassword password;

  public void setUsername(Username username) {
    this.username = username;
  }

  public void setPassword(PlainTextPassword password) {
    this.password = password;
  }

  public Username getUsername() {
    return username;
  }

  public PlainTextPassword getPassword() {
    return password;
  }

  /**
   * User Authtentication
   * Wrote the currentUser and the Login-Status to UserController
   * Or return a facesMessage if login data not correct
   *
   * @return
   * @throws UserNotFoundException
   */
  public String authenticate() throws UserNotFoundException {

    if (!authenticationService.authenticate(username, password)) {
      facesContext.addMessage(null, new FacesMessage("username or password wrong"));
    } else {
      User user = userRepository.findUser(username);
      event.fire(user);
    }

    return null;
  }

  /**
   * Kill the current User Session
   */
  public void logout() {
    facesContext.getExternalContext().invalidateSession();
  }

}
