#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${groupId}.controller;

import java.io.Serializable;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.Produces;
import javax.inject.Named;

import ${groupId}.core.user.CurrentUser;
import ${groupId}.domain.user.EncryptedPassword;
import ${groupId}.domain.user.Salt;
import ${groupId}.domain.user.User;
import ${groupId}.domain.user.Username;
import ${groupId}.presentation.common.events.LoggedIn;

/**
 * Created by pierre.liebsch on 25.12.13.
 */
@Named
@SessionScoped
public class UserController implements Serializable {

  private User user = new User(new Username("guest"), new EncryptedPassword("password", new Salt("12345678901234567890")));
  private boolean loggedIn = ${jsfPrimeFaces};

  /**
   * Get the current User
   *
   * @return
   */
  @Produces
  @CurrentUser
  public User getUser() {
    return user;
  }

  /**
   * This method set the currenUser, which can be injected with @CurrentUser
   *
   * @param user
   */
  private void setUser(@Observes(during = TransactionPhase.AFTER_SUCCESS) @LoggedIn User user) {
    this.user = user;
    loggedIn = true;
  }

  /**
   * Return true, if the User ist logged in.
   *
   * @return
   */
  public boolean isLoggedIn() {
    return loggedIn;
  }


}
