#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${groupId}.presentation.common.converter;

import javax.faces.application.FacesMessage;
import javax.faces.convert.ConverterException;
import javax.faces.convert.FacesConverter;

import ${groupId}.domain.user.Username;

/**
 * Created by pierre.liebsch on 16.12.13.
 */

@FacesConverter(forClass = Username.class)
public class UsernameConverter extends ValueObjectConverter<Username> {

  @Override
  protected Username createInstance(String value) {

    if (value == null || value.equals("")) {
      throw new ConverterException(new FacesMessage("Ungültiger Benutername"));
    }
    return new Username(value);
  }
}
