#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/*
 *
 * ${groupId}.web.filter.RequestLogFilter.java
 *
 *
 * This document contains trade secret data which is the property of OpenKnowledge GmbH. Information contained herein
 * may not be used, copied or disclosed in whole or part except as permitted by written agreement from OpenKnowledge
 * GmbH.
 *
 * Copyright (C) 2013 open knowledge GmbH / Oldenburg / Germany
 */
package ${groupId}.web.filter;

import java.io.IOException;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;

import org.apache.log4j.MDC;

/**
 * A filter which creates an unique id for each request and put it to Log4j Mapped Diagnostic Context (MDC).
 */
@WebFilter(urlPatterns = { "/*" })
public class RequestLogFilter implements Filter {

  static final String UNIQUE_ID = "UniqueId";

  @Override
  public void init(final FilterConfig config) throws ServletException {

  }

  @Override
  public void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain chain)
    throws IOException, ServletException {

    UUID uuid = UUID.randomUUID();
    MDC.put(UNIQUE_ID, uuid.toString());

    chain.doFilter(request, response);

    MDC.remove(UNIQUE_ID);
  }

  @Override
  public void destroy() {

  }
}
