#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/*
 *
 * ${groupId}.domain.AbstractJpaTest.java
 *
 *
 * This document contains trade secret data which is the property of OpenKnowledge GmbH. Information contained herein
 * may not be used, copied or disclosed in whole or part except as permitted by written agreement from OpenKnowledge
 * GmbH.
 *
 * Copyright (C) 2013 open knowledge GmbH / Oldenburg / Germany
 */
package ${groupId}.domain;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public class AbstractJpaTest {

  private static EntityManagerFactory entityManagerFactory;
  private EntityManager entityManager;


  @BeforeClass
  public static void createEntityManagerFactory() {

    Map<String, String> properties = new HashMap<>();
    properties.put("provider", "org.hibernate.ejb.HibernatePersistence");
    properties.put("javax.persistence.transactionType", "RESOURCE_LOCAL");
    properties.put("javax.persistence.jtaDataSource", null);
    properties.put("javax.persistence.jdbc.driver_class", "org.hsqldb.jdbcDriver");
    properties.put("javax.persistence.jdbc.url", "jdbc:hsqldb:mem:weblog");
    properties.put("hibernate.hbm2ddl.auto", "create");
    properties.put("hibernate.max_fetch_depth", "1");
    properties.put("hibernate.dialect", "org.hibernate.dialect.HSQLDialect");

    entityManagerFactory = Persistence.createEntityManagerFactory("local", properties);

  }

  @Before
  public void createEntityManager() {

    entityManager = entityManagerFactory.createEntityManager();
  }

  @After
  public void clearDatabase() {
    getEntityManager().getTransaction().begin();
    getEntityManager().createNativeQuery("TRUNCATE SCHEMA public AND COMMIT; ").executeUpdate();
    getEntityManager().getTransaction().commit();
  }

  @After
  public void closeEntityManager() {
    if (!entityManager.isOpen()) {
      return;
    }
    if (entityManager.getTransaction().isActive()) {
      entityManager.getTransaction().rollback();
    }
    entityManager.close();
  }

  public EntityManager getEntityManager() {
    return entityManager;
  }

  @AfterClass
  public static void closeEntityManagerFactory() {
    entityManagerFactory.close();
  }


}
