#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${groupId}.domain.user;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.enterprise.context.ApplicationScoped;


/**
 * Created by pierre.liebsch on 08.10.13.
 */
@ApplicationScoped
public class EncryptionService implements Serializable {

  public static final String CHARSET = "UTF-8";
  private static final String CRYPTOGRAPHY_ALGORITHM = "SHA-1";

  /**
   * Encrypt a PlainTextPassword with random Salt
   *
   * @param plainTextPassword
   * @return
   */
  public EncryptedPassword encrypt(PlainTextPassword plainTextPassword) {
    Salt salt = Salt.createSalt();
    return encrypt(plainTextPassword, salt);
  }

  /**
   * Encrypt a PlainTextPassword
   *
   * @param plainTextPassword
   * @param salt
   * @return
   */
  public EncryptedPassword encrypt(PlainTextPassword plainTextPassword, Salt salt) {
    try {
      MessageDigest digest = MessageDigest.getInstance(CRYPTOGRAPHY_ALGORITHM);

      byte[] crypted = digest.digest(addSaltToPlainTextPassword(plainTextPassword, salt));

      String encryptedPassword = new String(crypted, CHARSET);

      return new EncryptedPassword(encryptedPassword, salt);

    } catch (NoSuchAlgorithmException | UnsupportedEncodingException e) {
      throw new IllegalStateException(e);
    }
  }

  /**
   * Add a Salt to a PlainTextPassword
   *
   * @param plainTextPassword
   * @param salt
   * @return
   * @throws UnsupportedEncodingException
   */
  private byte[] addSaltToPlainTextPassword(PlainTextPassword plainTextPassword, Salt salt) throws UnsupportedEncodingException {
    return (plainTextPassword.getValue() + salt.getValue()).getBytes(CHARSET);
  }


}
