#!/bin/sh

CURRENTDIR=`pwd`
ARCHETYPEDIR=$CURRENTDIR'/target/generated-sources/archetype'
ARCHETYPEPROPERTIES='archetype-sample.properties'
MAVENPROFILES='archetype,tomee,glassfish'

echo "CURRENTDIR="$CURRENTDIR
echo "ARCHETYPEDIR="$ARCHETYPEDIR
echo "ACHETYPE.PROPERTIES="$ARCHETYPEPROPERTIES

# clean unnecessary stuff
mvn clean
mvn idea:clean
mvn eclipse:clean
rm -R .settings
rm -R bin
rm -R *.iml
rm -R .idea
rm -R .gwt
rm .DS_Store
rm -R war
rm -R www-test
rm -R gwt-unitCache

echo "mvn archetype:create-from-project -Darchetype.properties=$ARCHETYPEPROPERTIES"

mvn archetype:create-from-project -Darchetype.properties=$ARCHETYPEPROPERTIES -P $MAVENPROFILES
echo Archetype generiert
echo Archetype wird installiert...
sleep 1

cd "$ARCHETYPEDIR" && mvn -B clean install
#echo Archetype installiert
#echo Abgeschlossen
cd $CURRENTDIR
sleep 1


