#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/*
 * ${groupId}.presentation.common.PublicIdGeneratorTest.java
 *
 *
 * This document contains trade secret data which is the property of OpenKnowledge GmbH. Information contained herein
 * may not be used, copied or disclosed in whole or part except as permitted by written agreement from OpenKnowledge
 * GmbH.
 *
 * Copyright(C)2013 open knowledge GmbH / Oldenburg / Germany
 */
package ${groupId}.presentation.common;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

import ${groupId}.core.test.DevelopmentTests;

/**
 * Test class for {@link PublicIdGenerator}.
 */
@Ignore("weils nicht geht")
@Category(DevelopmentTests.class)
public class PublicIdGeneratorTest {

  private static final String PUBLIC_ID = "123456";

  private PublicIdGenerator idGenerator;

  @Before
  public void setUp()
    throws Exception {

    idGenerator = new PublicIdGenerator();
  }

  @Test
  public void generatePublicId()
    throws Exception {

    String publicId = idGenerator.generatePublicId(Long.class, Long.getLong(PUBLIC_ID));
    assertNotNull(publicId);

    String newPublicId = idGenerator.generatePublicId(Long.class, Long.getLong(PUBLIC_ID));
    assertNotNull(newPublicId);
    assertEquals(publicId, newPublicId);
  }

  @Test
  public void lookup()
    throws Exception {

    Long privateId = Long.getLong(PUBLIC_ID);
    String publicId = idGenerator.generatePublicId(Long.class, privateId);
    assertNotNull(publicId);

    Long lookup = (Long)idGenerator.lookup(Long.class, publicId);

    assertNotNull(lookup);
    assertEquals(privateId, lookup);
  }

  @Test(expected = IllegalStateException.class)
  public void lookupCheckIllegalStateInvalidPublicId()
    throws Exception {

    idGenerator.lookup(String.class, "dummy");
  }

  @Test(expected = IllegalStateException.class)
  public void lookupCheckIllegalStateInvalidClazz()
    throws Exception {

    String publicId = idGenerator.generatePublicId(Long.class, Long.getLong(PUBLIC_ID));
    idGenerator.lookup(String.class, publicId);
  }
}
