#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${groupId}.domain.user;

import java.io.Serializable;
import javax.persistence.Embeddable;
import javax.persistence.Transient;

import ${groupId}.domain.AbstractValueObject;


/**
 * Created by pierre.liebsch on 30.09.13.
 */
@Embeddable
public class EncryptedPassword extends AbstractValueObject<String> implements Comparable<AbstractValueObject<String>>, Serializable {

  @Transient
  private Salt salt;

  protected EncryptedPassword() {
  }

  public EncryptedPassword(String value, Salt salt) {
    super(value + salt.getValue());
  }

  /**
   * Get the Salt from the EncryptedPassword
   *
   * @return
   */
  public Salt getSalt() {
    if (salt == null) {
      salt = new Salt(this);
    }
    return salt;
  }


}
