/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.archetype.controller;

import de.openknowledge.archetype.domain.user.AuthenticationService;
import de.openknowledge.archetype.domain.user.PlainTextPassword;
import de.openknowledge.archetype.domain.user.User;
import de.openknowledge.archetype.domain.user.UserNotFoundException;
import de.openknowledge.archetype.domain.user.UserRepository;
import de.openknowledge.archetype.domain.user.Username;
import de.openknowledge.archetype.presentation.common.events.LoggedIn;
import java.io.Serializable;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;

@Named
@Stateless
public class AuthenticationController
implements Serializable {
    @Inject
    private FacesContext facesContext;
    @Inject
    private AuthenticationService authenticationService;
    @Inject
    @LoggedIn
    private Event<User> event;
    @Inject
    private UserRepository userRepository;
    @Inject
    private EntityManager entityManager;
    private Username username;
    private PlainTextPassword password;

    public void setUsername(Username username) {
        this.username = username;
    }

    public void setPassword(PlainTextPassword password) {
        this.password = password;
    }

    public Username getUsername() {
        return this.username;
    }

    public PlainTextPassword getPassword() {
        return this.password;
    }

    public String authenticate() throws UserNotFoundException {
        if (!this.authenticationService.authenticate(this.username, this.password)) {
            this.facesContext.addMessage(null, new FacesMessage("username or password wrong"));
        } else {
            User user = this.userRepository.findUser(this.username);
            this.event.fire((Object)user);
        }
        return null;
    }

    public void logout() {
        this.facesContext.getExternalContext().invalidateSession();
    }
}

