/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.archetype.presentation.common.converter;

import de.openknowledge.archetype.domain.AbstractEntity;
import de.openknowledge.archetype.presentation.common.PublicIdGenerator;
import java.io.Serializable;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;

public abstract class EntityConverter<C extends AbstractEntity>
implements Converter,
Serializable {
    private final Class<C> clazz;
    @Inject
    private EntityManager entityManager;
    @Inject
    private PublicIdGenerator idGenerator;

    protected EntityConverter(Class<C> clazz) {
        this.clazz = clazz;
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        Object entityId = this.idGenerator.lookup(this.clazz, value);
        AbstractEntity entity = (AbstractEntity)this.entityManager.find(this.clazz, entityId);
        return entity;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value == null) {
            return "";
        }
        Long entityId = ((AbstractEntity)value).getId();
        String publicId = this.idGenerator.generatePublicId(this.clazz, (Object)entityId);
        return publicId;
    }
}

