/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.archetype.core.transaction;

import de.openknowledge.archetype.core.transaction.Transactional;
import de.openknowledge.archetype.core.transaction.TransactionalType;
import java.io.Serializable;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.transaction.UserTransaction;

@Transactional
@Interceptor
public class TransactionInterceptor
implements Serializable {
    @Inject
    private UserTransaction utx;

    @AroundInvoke
    public Object applyTransaction(InvocationContext ic) throws Exception {
        Transactional tx = ic.getMethod().getAnnotation(Transactional.class);
        if (tx.value() == TransactionalType.REQUIRED) {
            Object ret;
            boolean startedTransaction = false;
            if (this.utx.getStatus() != 0) {
                this.utx.begin();
                startedTransaction = true;
            }
            try {
                ret = ic.proceed();
                if (startedTransaction) {
                    this.utx.commit();
                }
            }
            catch (Exception t) {
                if (startedTransaction) {
                    this.utx.rollback();
                }
                throw t;
            }
            return ret;
        }
        if (tx.value() == TransactionalType.REQUIRES_NEW) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return ic.proceed();
    }
}

