/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.archetype.core.trace;

import de.openknowledge.archetype.core.trace.Trace;
import java.util.Arrays;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.log4j.Logger;

@Trace
@Interceptor
public class TraceInterceptor {
    private static final Logger LOGGER = Logger.getLogger(TraceInterceptor.class);

    @AroundInvoke
    public Object traceCall(InvocationContext ctx) throws Exception {
        LOGGER.debug((Object)("Calling " + ctx.getMethod() + " of " + ctx.getTarget() + " with arguments " + Arrays.toString(ctx.getParameters())));
        try {
            Object result = ctx.proceed();
            LOGGER.debug((Object)("Returning " + result + " for " + ctx.getMethod() + " in " + ctx.getTarget()));
            return result;
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Caught exception while processing " + ctx.getTarget() + " at " + ctx.getMethod()), (Throwable)e);
            throw e;
        }
    }
}

