/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.common.property;

import de.openknowledge.cdi.common.property.ApplicationPropertyBinding;
import de.openknowledge.cdi.common.property.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.spi.InjectionPoint;

public class ApplicationProperty {
    private String propertyKey;
    private Map<String, ApplicationPropertyBinding> values = new HashMap<String, ApplicationPropertyBinding>();

    public ApplicationProperty(String aPropertyKey) {
        this.propertyKey = aPropertyKey;
    }

    public void registerInjectionPoint(InjectionPoint p, Property aProperty, String currentValue) {
        String binding = p.getMember().getDeclaringClass().getName() + "." + p.getMember().getName();
        if (this.values.containsKey(binding)) {
            return;
        }
        this.values.put(binding, new ApplicationPropertyBinding(binding, aProperty, currentValue));
    }

    public Collection<ApplicationPropertyBinding> getPropertyUsages() {
        return new ArrayList<ApplicationPropertyBinding>(this.values.values());
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationProperty that = (ApplicationProperty)o;
        return !(this.propertyKey != null ? !this.propertyKey.equals(that.propertyKey) : that.propertyKey != null);
    }

    public int hashCode() {
        return this.propertyKey != null ? this.propertyKey.hashCode() : 0;
    }
}

